/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage.IForeignVariableStorage;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage.IScopedVariableStorage;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.storage.ITempVariableStorage;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.util.PooledStringHashMap;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.util.PooledStringHashSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class VariableStorage
implements ITempVariableStorage,
IScopedVariableStorage,
IForeignVariableStorage {
    private static final int TEMP_INIT_CAPACITY = 16;
    private static final int SCOPED_INIT_CAPACITY = 16;
    private Object[] stackFrame = new Object[16];
    private final PooledStringHashMap<VariableValueHolder> scopedMap = new PooledStringHashMap(16);
    private PooledStringHashMap<VariableValueHolder> publicMap = new PooledStringHashMap();

    private void ensureStackFrameSize(int size) {
        if (this.stackFrame.length >= size) {
            return;
        }
        if (size < this.stackFrame.length * 2) {
            size = this.stackFrame.length * 2;
        }
        this.stackFrame = Arrays.copyOf(this.stackFrame, size);
    }

    @Override
    public Object getTemp(int index) {
        this.ensureStackFrameSize(index + 1);
        return this.stackFrame[index];
    }

    @Override
    public void setTemp(int index, Object value) {
        this.ensureStackFrameSize(index + 1);
        this.stackFrame[index] = value;
    }

    @Override
    public Object getScoped(int name) {
        VariableValueHolder valueHolder = (VariableValueHolder)this.scopedMap.computeIfAbsent(name, n -> new VariableValueHolder());
        return valueHolder.value;
    }

    @Override
    public void setScoped(int name, Object value) {
        VariableValueHolder valueHolder = (VariableValueHolder)this.scopedMap.computeIfAbsent(name, n -> new VariableValueHolder());
        valueHolder.value = value;
    }

    @Override
    public Object getPublic(int name) {
        VariableValueHolder valueHolder = (VariableValueHolder)this.publicMap.get(name);
        if (valueHolder != null) {
            return valueHolder.value;
        }
        return null;
    }

    public void initialize(@Nullable PooledStringHashSet publicVariableNames) {
        Arrays.fill(this.stackFrame, null);
        this.scopedMap.clear();
        PooledStringHashMap newPublicMap = new PooledStringHashMap();
        if (publicVariableNames != null) {
            IntIterator intIterator = publicVariableNames.iterator();
            while (intIterator.hasNext()) {
                int publicVariableName = (Integer)intIterator.next();
                VariableValueHolder value = new VariableValueHolder();
                this.scopedMap.put(publicVariableName, value);
                newPublicMap.put(publicVariableName, value);
            }
        }
        newPublicMap.trim();
        this.publicMap = newPublicMap;
    }

    private static class VariableValueHolder {
        public Object value = null;

        private VariableValueHolder() {
        }
    }
}

