/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.BoneKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.CatmullRomKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.LinearKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.RawBoneKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.TransitionKeyFrame;
import java.util.List;

public interface EasingType {
    public static final EasingType LINEAR = EasingType::buildLinearKeyFrame;
    public static final EasingType CATMULLROM = EasingType::buildCatmullRomKeyFrame;

    public BoneKeyFrame buildKeyFrame(List<RawBoneKeyFrame> var1, int var2);

    public static TransitionKeyFrame buildTransitionKeyFrame(List<RawBoneKeyFrame> keyFrames) {
        RawBoneKeyFrame transitionDst = keyFrames.get(0);
        return new TransitionKeyFrame(transitionDst.startTick(), transitionDst.preValue(), transitionDst.postValue());
    }

    public static BoneKeyFrame buildLinearKeyFrame(List<RawBoneKeyFrame> keyFrames, int index) {
        if (index == 0) {
            return EasingType.buildTransitionKeyFrame(keyFrames);
        }
        RawBoneKeyFrame begin = keyFrames.get(index - 1);
        RawBoneKeyFrame end = keyFrames.get(index);
        return new LinearKeyFrame(begin.startTick(), end.startTick() - begin.startTick(), begin.postValue(), end.preValue(), end.postValue());
    }

    public static BoneKeyFrame buildCatmullRomKeyFrame(List<RawBoneKeyFrame> keyFrames, int index) {
        if (index == 0) {
            return EasingType.buildTransitionKeyFrame(keyFrames);
        }
        RawBoneKeyFrame left = keyFrames.get(Math.max(0, index - 2));
        RawBoneKeyFrame begin = keyFrames.get(index - 1);
        RawBoneKeyFrame end = keyFrames.get(index);
        RawBoneKeyFrame right = keyFrames.get(Math.min(keyFrames.size() - 1, index + 1));
        return new CatmullRomKeyFrame(begin.startTick(), end.startTick() - begin.startTick(), left.postValue(), begin.postValue(), end.preValue(), right.preValue(), end.postValue());
    }
}

