/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event.maid;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class HandleBackpackEvent {
    @SubscribeEvent
    public static void onInteractMaid(InteractMaidEvent event) {
        ItemStack stack = event.getStack();
        Player player = event.getPlayer();
        EntityMaid maid = event.getMaid();
        IMaidBackpack maidBackpack = maid.getMaidBackpackType();
        if (stack.m_204117_(Tags.Items.SHEARS)) {
            if (maid.m_21830_((LivingEntity)player) && !maid.backpackHasDelay() && maidBackpack != BackpackManager.getEmptyBackpack()) {
                maid.setBackpackDelay();
                player.m_36335_().m_41524_(stack.m_41720_(), 20);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)maidBackpack.getTakeOffItemStack(stack, player, maid));
                maidBackpack.onTakeOff(stack, player, maid);
                maid.setMaidBackpackType(BackpackManager.getEmptyBackpack());
                stack.m_41622_(1, (LivingEntity)player, m -> m.m_21190_(InteractionHand.MAIN_HAND));
                maid.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
                event.setCanceled(true);
            }
        } else {
            BackpackManager.findBackpack(stack).ifPresent(backpack -> {
                if (maid.m_21830_((LivingEntity)player) && !maid.backpackHasDelay() && backpack != BackpackManager.getEmptyBackpack() && backpack != maidBackpack) {
                    maid.setBackpackDelay();
                    BackpackManager.addBackpackCooldown(player);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)maidBackpack.getTakeOffItemStack(stack, player, maid));
                    maidBackpack.onTakeOff(stack, player, maid);
                    maid.setMaidBackpackType((IMaidBackpack)backpack);
                    stack.m_41774_(1);
                    backpack.onPutOn(stack, player, maid);
                    maid.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
                    LivingEntity patt2830$temp = maid.m_269323_();
                    if (patt2830$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt2830$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_backpack");
                    }
                    event.setCanceled(true);
                }
            });
        }
    }
}

