/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;

public class TaskFeedOwner
implements IFeedTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "feed");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42580_.m_7968_();
    }

    @Override
    public boolean isFood(ItemStack stack, Player owner) {
        FoodProperties food;
        if (stack.m_41720_() == Items.f_42455_) {
            for (MobEffectInstance effect : owner.m_21220_()) {
                if (!this.isHarmfulEffect(effect) || effect.m_19557_() <= 60 || !effect.isCurativeItem(stack)) continue;
                return true;
            }
            return false;
        }
        if (stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner) != null && (food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner)) != null) {
            return food.m_38749_().isEmpty() || food.m_38749_().stream().noneMatch(pair -> this.isHarmfulEffect((MobEffectInstance)pair.getFirst()));
        }
        return false;
    }

    @Override
    public IFeedTask.Priority getPriority(ItemStack stack, Player owner) {
        if (stack.m_150930_(Items.f_42455_)) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.m_150930_(Items.f_42787_) && owner.m_21023_(MobEffects.f_19614_)) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.m_150930_(Items.f_42436_)) {
            if (owner.m_21223_() * 2.0f < owner.m_21233_()) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOWEST;
        }
        if (stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner) != null) {
            int hunger;
            FoodData foodData = owner.m_36324_();
            if (!foodData.m_38721_()) {
                return IFeedTask.Priority.LOWEST;
            }
            FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)owner);
            int heal = 0;
            if (food != null) {
                heal = food.m_38744_();
            }
            if (heal >= (hunger = 20 - foodData.m_38702_())) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOW;
        }
        return IFeedTask.Priority.NONE;
    }

    @Override
    public ItemStack feed(ItemStack stack, Player owner) {
        if (stack.m_41780_() == UseAnim.DRINK) {
            owner.f_19853_.m_6269_(null, (Entity)owner, stack.m_41615_(), SoundSource.NEUTRAL, 0.5f, owner.f_19853_.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        return stack.m_41720_().m_5922_(stack, owner.f_19853_, (LivingEntity)owner);
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FEED.get(), 0.3f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedOwnerTask(this, 2, 0.6f)))});
    }

    private boolean isHarmfulEffect(MobEffectInstance effect) {
        return effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL;
    }
}

