/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.PickType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;

public class MaidConfigManager {
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";
    private static final String MAID_SUB_CONFIG_TAG = "MaidSubConfig";
    private static final String BACKPACK_SHOW_TAG = "BackpackShow";
    private static final String BACK_ITEM_SHOW_TAG = "BackItemShow";
    private static final String CHATBUBBLE_SHOW_TAG = "ChatBubbleShow";
    private static final String SOUND_FREQ_TAG = "SoundFreq";
    private static final String PICKUP_TYPE_TAG = "PickupType";
    private static final String OPEN_DOOR_TAG = "OpenDoor";
    private static final String OPEN_FENCE_GATE_TAG = "OpenFenceGate";
    private static final String ACTIVE_CLIMBING_TAG = "ActiveClimbing";
    private final SynchedEntityData entityData;

    MaidConfigManager(SynchedEntityData entityData) {
        this.entityData = entityData;
    }

    void defineSynchedData() {
        this.entityData.m_135372_(EntityMaid.DATA_PICKUP, (Object)true);
        this.entityData.m_135372_(EntityMaid.DATA_HOME_MODE, (Object)false);
        this.entityData.m_135372_(EntityMaid.DATA_RIDEABLE, (Object)true);
        this.entityData.m_135372_(EntityMaid.BACKPACK_SHOW, (Object)true);
        this.entityData.m_135372_(EntityMaid.BACK_ITEM_SHOW, (Object)true);
        this.entityData.m_135372_(EntityMaid.CHATBUBBLE_SHOW, (Object)true);
        this.entityData.m_135372_(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(1.0f));
        this.entityData.m_135372_(EntityMaid.PICKUP_TYPE, (Object)PickType.ALL.ordinal());
        this.entityData.m_135372_(EntityMaid.OPEN_DOOR, (Object)true);
        this.entityData.m_135372_(EntityMaid.OPEN_FENCE_GATE, (Object)true);
        this.entityData.m_135372_(EntityMaid.ACTIVE_CLIMBING, (Object)true);
    }

    void addAdditionalSaveData(CompoundTag compound) {
        compound.m_128379_(PICKUP_TAG, this.isPickup());
        compound.m_128379_(HOME_TAG, this.isHomeModeEnable());
        compound.m_128379_(RIDEABLE_TAG, this.isRideable());
        CompoundTag maidSubConfig = new CompoundTag();
        maidSubConfig.m_128379_(BACKPACK_SHOW_TAG, this.isShowBackpack());
        maidSubConfig.m_128379_(BACK_ITEM_SHOW_TAG, this.isShowBackItem());
        maidSubConfig.m_128379_(CHATBUBBLE_SHOW_TAG, this.isChatBubbleShow());
        maidSubConfig.m_128350_(SOUND_FREQ_TAG, this.getSoundFreq());
        maidSubConfig.m_128405_(PICKUP_TYPE_TAG, this.getPickupType().ordinal());
        maidSubConfig.m_128379_(OPEN_DOOR_TAG, this.isOpenDoor());
        maidSubConfig.m_128379_(OPEN_FENCE_GATE_TAG, this.isOpenFenceGate());
        maidSubConfig.m_128379_(ACTIVE_CLIMBING_TAG, this.isActiveClimbing());
        compound.m_128365_(MAID_SUB_CONFIG_TAG, (Tag)maidSubConfig);
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128425_(PICKUP_TAG, 1)) {
            this.setPickup(compound.m_128471_(PICKUP_TAG));
        }
        if (compound.m_128425_(HOME_TAG, 1)) {
            this.setHomeModeEnable(compound.m_128471_(HOME_TAG));
        }
        if (compound.m_128425_(RIDEABLE_TAG, 1)) {
            this.setRideable(compound.m_128471_(RIDEABLE_TAG));
        }
        if (compound.m_128425_(MAID_SUB_CONFIG_TAG, 10)) {
            CompoundTag maidSubConfig = compound.m_128469_(MAID_SUB_CONFIG_TAG);
            if (maidSubConfig.m_128441_(BACKPACK_SHOW_TAG)) {
                this.setShowBackpack(maidSubConfig.m_128471_(BACKPACK_SHOW_TAG));
            }
            if (maidSubConfig.m_128441_(BACK_ITEM_SHOW_TAG)) {
                this.setShowBackItem(maidSubConfig.m_128471_(BACK_ITEM_SHOW_TAG));
            }
            if (maidSubConfig.m_128441_(CHATBUBBLE_SHOW_TAG)) {
                this.setChatBubbleShow(maidSubConfig.m_128471_(CHATBUBBLE_SHOW_TAG));
            }
            if (maidSubConfig.m_128441_(SOUND_FREQ_TAG)) {
                this.setSoundFreq(maidSubConfig.m_128457_(SOUND_FREQ_TAG));
            }
            if (maidSubConfig.m_128441_(PICKUP_TYPE_TAG)) {
                this.setPickupType(PickType.values()[maidSubConfig.m_128451_(PICKUP_TYPE_TAG)]);
            }
            if (maidSubConfig.m_128441_(OPEN_DOOR_TAG)) {
                this.setOpenDoor(maidSubConfig.m_128471_(OPEN_DOOR_TAG));
            }
            if (maidSubConfig.m_128441_(OPEN_FENCE_GATE_TAG)) {
                this.setOpenFenceGate(maidSubConfig.m_128471_(OPEN_FENCE_GATE_TAG));
            }
            if (maidSubConfig.m_128441_(ACTIVE_CLIMBING_TAG)) {
                this.setActiveClimbing(maidSubConfig.m_128471_(ACTIVE_CLIMBING_TAG));
            }
        }
    }

    boolean isHomeModeEnable() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.DATA_HOME_MODE);
    }

    void setHomeModeEnable(boolean enable) {
        this.entityData.m_135381_(EntityMaid.DATA_HOME_MODE, (Object)enable);
    }

    boolean isPickup() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.DATA_PICKUP);
    }

    void setPickup(boolean isPickup) {
        this.entityData.m_135381_(EntityMaid.DATA_PICKUP, (Object)isPickup);
    }

    boolean isRideable() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.DATA_RIDEABLE);
    }

    void setRideable(boolean rideable) {
        this.entityData.m_135381_(EntityMaid.DATA_RIDEABLE, (Object)rideable);
    }

    public SyncNetwork getSyncNetwork() {
        return new SyncNetwork(this.isShowBackpack(), this.isShowBackItem(), this.isChatBubbleShow(), this.getSoundFreq(), this.getPickupType(), this.isOpenDoor(), this.isOpenFenceGate(), this.isActiveClimbing());
    }

    public boolean isShowBackpack() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.BACKPACK_SHOW);
    }

    public void setShowBackpack(boolean show) {
        this.entityData.m_135381_(EntityMaid.BACKPACK_SHOW, (Object)show);
    }

    public boolean isShowBackItem() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.BACK_ITEM_SHOW);
    }

    public void setShowBackItem(boolean show) {
        this.entityData.m_135381_(EntityMaid.BACK_ITEM_SHOW, (Object)show);
    }

    public boolean isChatBubbleShow() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.CHATBUBBLE_SHOW);
    }

    public void setChatBubbleShow(boolean show) {
        this.entityData.m_135381_(EntityMaid.CHATBUBBLE_SHOW, (Object)show);
    }

    public float getSoundFreq() {
        return ((Float)this.entityData.m_135370_(EntityMaid.SOUND_FREQ)).floatValue();
    }

    public void setSoundFreq(float freq) {
        this.entityData.m_135381_(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(Mth.m_14036_((float)freq, (float)0.0f, (float)1.0f)));
    }

    public PickType getPickupType() {
        int index = (Integer)this.entityData.m_135370_(EntityMaid.PICKUP_TYPE);
        return PickType.values()[index];
    }

    public void setPickupType(PickType type) {
        this.entityData.m_135381_(EntityMaid.PICKUP_TYPE, (Object)type.ordinal());
    }

    public boolean isOpenDoor() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.OPEN_DOOR);
    }

    public void setOpenDoor(boolean openDoor) {
        this.entityData.m_135381_(EntityMaid.OPEN_DOOR, (Object)openDoor);
    }

    public boolean isOpenFenceGate() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.OPEN_FENCE_GATE);
    }

    public void setOpenFenceGate(boolean openFenceGate) {
        this.entityData.m_135381_(EntityMaid.OPEN_FENCE_GATE, (Object)openFenceGate);
    }

    public boolean isActiveClimbing() {
        return (Boolean)this.entityData.m_135370_(EntityMaid.ACTIVE_CLIMBING);
    }

    public void setActiveClimbing(boolean activeClimbing) {
        this.entityData.m_135381_(EntityMaid.ACTIVE_CLIMBING, (Object)activeClimbing);
    }

    public static final class SyncNetwork {
        private boolean showBackpack;
        private boolean showBackItem;
        private boolean showChatBubble;
        private float soundFreq;
        private PickType pickType;
        private boolean openDoor;
        private boolean openFenceGate;
        private boolean activeClimbing;

        public SyncNetwork(boolean showBackpack, boolean showBackItem, boolean showChatBubble, float soundFreq, PickType pickType, boolean openDoor, boolean openFenceGate, boolean activeClimbing) {
            this.showBackpack = showBackpack;
            this.showBackItem = showBackItem;
            this.showChatBubble = showChatBubble;
            this.soundFreq = soundFreq;
            this.pickType = pickType;
            this.openDoor = openDoor;
            this.openFenceGate = openFenceGate;
            this.activeClimbing = activeClimbing;
        }

        public static void encode(SyncNetwork message, FriendlyByteBuf buf) {
            buf.writeBoolean(message.showBackpack);
            buf.writeBoolean(message.showBackItem);
            buf.writeBoolean(message.showChatBubble);
            buf.writeFloat(message.soundFreq);
            buf.m_130068_((Enum)message.pickType);
            buf.writeBoolean(message.openDoor);
            buf.writeBoolean(message.openFenceGate);
            buf.writeBoolean(message.activeClimbing);
        }

        public static SyncNetwork decode(FriendlyByteBuf buf) {
            boolean showBackpack = buf.readBoolean();
            boolean showBackItem = buf.readBoolean();
            boolean showChatBubble = buf.readBoolean();
            float soundFreq = buf.readFloat();
            PickType pickType = (PickType)buf.m_130066_(PickType.class);
            boolean openDoor = buf.readBoolean();
            boolean openFenceGate = buf.readBoolean();
            boolean activeClimbing = buf.readBoolean();
            return new SyncNetwork(showBackpack, showBackItem, showChatBubble, soundFreq, pickType, openDoor, openFenceGate, activeClimbing);
        }

        public static void handle(SyncNetwork message, EntityMaid maid) {
            MaidConfigManager configManager = maid.getConfigManager();
            configManager.setShowBackpack(message.showBackpack);
            configManager.setShowBackItem(message.showBackItem);
            configManager.setChatBubbleShow(message.showChatBubble);
            configManager.setSoundFreq(message.soundFreq);
            configManager.setPickupType(message.pickType);
            configManager.setOpenDoor(message.openDoor);
            configManager.setOpenFenceGate(message.openFenceGate);
            configManager.setActiveClimbing(message.activeClimbing);
        }

        public boolean showBackpack() {
            return this.showBackpack;
        }

        public boolean showBackItem() {
            return this.showBackItem;
        }

        public boolean showChatBubble() {
            return this.showChatBubble;
        }

        public float soundFreq() {
            return this.soundFreq;
        }

        public PickType pickType() {
            return this.pickType;
        }

        public boolean openDoor() {
            return this.openDoor;
        }

        public boolean openFenceGate() {
            return this.openFenceGate;
        }

        public boolean activeClimbing() {
            return this.activeClimbing;
        }

        public void setShowBackpack(boolean showBackpack) {
            this.showBackpack = showBackpack;
        }

        public void setShowBackItem(boolean showBackItem) {
            this.showBackItem = showBackItem;
        }

        public void setShowChatBubble(boolean showChatBubble) {
            this.showChatBubble = showChatBubble;
        }

        public void setSoundFreq(float soundFreq) {
            this.soundFreq = Mth.m_14036_((float)soundFreq, (float)0.0f, (float)1.0f);
        }

        public void setPickType(PickType pickType) {
            this.pickType = pickType;
        }

        public void setOpenDoor(boolean openDoor) {
            this.openDoor = openDoor;
        }

        public void setOpenFenceGate(boolean openFenceGate) {
            this.openFenceGate = openFenceGate;
        }

        public void setActiveClimbing(boolean activeClimbing) {
            this.activeClimbing = activeClimbing;
        }
    }
}

