/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.network.NetworkHooks;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 0;
    public static final int SECOND_STAGE = 1;
    public static final int THIRD_STAGE = 2;
    public static final int MAX_TEXTURE_SIZE = 8;
    private static final EntityDataAccessor<Integer> OPEN_STAGE = SynchedEntityData.m_135353_(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityType<EntityBox> TYPE = EntityType.Builder.m_20704_(EntityBox::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20702_(10).m_20712_("box");
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";
    public long thirdStageTimeStamp = 0L;
    private int thirdStageTicks = 0;

    public EntityBox(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setRandomTexture();
    }

    public EntityBox(Level worldIn) {
        this(TYPE, worldIn);
    }

    public void m_6075_() {
        if (!this.m_20068_() && !this.m_20096_()) {
            this.m_6478_(MoverType.SELF, this.m_20184_().m_82520_(0.0, -0.1, 0.0));
        }
        super.m_6075_();
        int stage = this.getOpenStage();
        if (stage == 0) {
            this.m_20197_().stream().filter(e -> e instanceof TamableAnimal).forEach(e -> this.applyInvisibilityEffect((TamableAnimal)e));
        } else if (stage == 2) {
            ++this.thirdStageTicks;
            if (this.thirdStageTicks > 100) {
                this.addStageChange();
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        this.addStageChange();
        if (this.getOpenStage() == 1) {
            this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.getOpenStage() == 2) {
            this.thirdStageTimeStamp = System.currentTimeMillis();
            this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        this.m_5496_((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 2.0f);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OPEN_STAGE, (Object)0);
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(STAGE_TAG)) {
            this.setOpenStage(compound.m_128451_(STAGE_TAG));
        }
        if (compound.m_128441_(TEXTURE_TAG)) {
            this.setTextureIndex(compound.m_128451_(TEXTURE_TAG));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(STAGE_TAG, this.getOpenStage());
        compound.m_128405_(TEXTURE_TAG, this.getTextureIndex());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public int getOpenStage() {
        return (Integer)this.f_19804_.m_135370_(OPEN_STAGE);
    }

    private void setOpenStage(int stage) {
        this.f_19804_.m_135381_(OPEN_STAGE, (Object)stage);
    }

    public int getTextureIndex() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
    }

    private void setTextureIndex(int index) {
        this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)Mth.m_14045_((int)index, (int)1, (int)7));
    }

    public void setRandomTexture() {
        this.setTextureIndex(this.f_19796_.m_188503_(8));
    }

    private void addStageChange() {
        this.setOpenStage(this.getOpenStage() + 1);
        if (this.getOpenStage() > 2) {
            this.m_6074_();
        }
    }

    public void m_6074_() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 20, 1.0, 1.0, 1.0, 0.2);
            ResourceLocation table = this.m_6095_().m_20677_();
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(table);
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)this.m_269291_().m_287172_());
            LootParams params = builder.m_287235_(LootContextParamSets.f_81415_);
            lootTable.m_287276_(params, 0L, arg_0 -> ((EntityBox)this).m_19983_(arg_0));
        }
        super.m_6074_();
    }

    private void applyInvisibilityEffect(TamableAnimal tameable) {
        tameable.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 2, 1, false, false));
    }
}

