/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

public record ChatBubbleDataCollection(Long2ObjectSortedMap<IChatBubbleData> chatBubbles) {
    public static final int MAX_SIZE = 5;

    public static ChatBubbleDataCollection getEmptyCollection() {
        return new ChatBubbleDataCollection((Long2ObjectSortedMap<IChatBubbleData>)new Long2ObjectAVLTreeMap());
    }

    public long add(IChatBubbleData chatBubbleData) {
        long existTime = System.currentTimeMillis() + (long)chatBubbleData.existTick() * 50L;
        if (this.chatBubbles.size() >= 5) {
            return this.addWhenFull(chatBubbleData, existTime);
        }
        this.chatBubbles.put(existTime, (Object)chatBubbleData);
        return existTime;
    }

    private long addWhenFull(IChatBubbleData chatBubbleData, long existTime) {
        long remove = -1L;
        for (Long2ObjectMap.Entry entry : this.chatBubbles.long2ObjectEntrySet()) {
            long key = entry.getLongKey();
            IChatBubbleData value = (IChatBubbleData)entry.getValue();
            if (value.priority() > chatBubbleData.priority()) continue;
            remove = key;
            break;
        }
        if (remove == -1L) {
            return -1L;
        }
        this.chatBubbles.remove(remove);
        this.chatBubbles.put(existTime, (Object)chatBubbleData);
        return existTime;
    }

    public boolean update() {
        long currentTime = System.currentTimeMillis();
        LongBidirectionalIterator iterator = this.chatBubbles.keySet().iterator();
        boolean dirty = false;
        while (iterator.hasNext()) {
            long time = iterator.nextLong();
            if (currentTime - time > 0L) {
                iterator.remove();
                dirty = true;
                continue;
            }
            return dirty;
        }
        return dirty;
    }

    public int size() {
        return this.chatBubbles.size();
    }

    public LongSortedSet keySet() {
        return this.chatBubbles.keySet();
    }

    public IChatBubbleData get(long key) {
        return (IChatBubbleData)this.chatBubbles.get(key);
    }

    public boolean containsKey(long key) {
        return this.chatBubbles.containsKey(key);
    }

    public void remove(long key) {
        this.chatBubbles.remove(key);
    }

    public void put(long key, IChatBubbleData bubble) {
        this.chatBubbles.put(key, (Object)bubble);
    }

    public boolean isEmpty() {
        return this.chatBubbles == null || this.chatBubbles.isEmpty();
    }

    public IChatBubbleData getFirst() {
        return (IChatBubbleData)this.chatBubbles.get(this.chatBubbles.firstLongKey());
    }

    public IChatBubbleData getLast() {
        return (IChatBubbleData)this.chatBubbles.get(this.chatBubbles.lastLongKey());
    }

    public ObjectIterator<IChatBubbleData> iterator() {
        return this.chatBubbles.values().iterator();
    }
}

