/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class TankBackpackData
extends SimpleContainer
implements IBackpackData {
    public static final int CAPACITY = 10000;
    private static final int INPUT_INDEX = 0;
    private static final int OUTPUT_INDEX = 1;
    private final EntityMaid maid;
    private final FluidTank tank = new FluidTank(10000);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return TankBackpackData.this.tankFluidCount;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                TankBackpackData.this.tankFluidCount = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int tankFluidCount = 0;

    public TankBackpackData(EntityMaid maid) {
        super(2);
        this.maid = maid;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (!this.maid.f_19853_.f_46443_) {
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            if (index == 0) {
                MaidFluidUtil.bucketToTank(stack, (IFluidHandler)this.tank, (IItemHandler)availableInv);
            }
            if (index == 1) {
                MaidFluidUtil.tankToBucket(stack, (IFluidHandler)this.tank, (IItemHandler)availableInv);
            }
            this.tankFluidCount = this.tank.getFluidAmount();
            ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)this.tank.getFluid().getFluid());
            if (key != null) {
                this.maid.setBackpackFluid(key.toString());
            }
        }
        super.m_6836_(index, stack);
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(CompoundTag tag, EntityMaid maid) {
        this.loadTank(tag.m_128469_("Tanks"), maid);
        this.m_7797_(tag.m_128437_("Items", 10));
    }

    @Override
    public void save(CompoundTag tag, EntityMaid maid) {
        tag.m_128365_("Tanks", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128365_("Items", (Tag)this.m_7927_());
    }

    @Override
    public void serverTick(EntityMaid maid) {
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void loadTank(CompoundTag nbt, EntityMaid maid) {
        this.tank.readFromNBT(nbt);
        this.tankFluidCount = this.tank.getFluidAmount();
        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)this.tank.getFluid().getFluid());
        if (key != null) {
            maid.setBackpackFluid(key.toString());
        }
    }
}

