/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MaidClimbTask
extends Behavior<EntityMaid> {
    public MaidClimbTask() {
        super((Map)ImmutableMap.of());
    }

    protected void start(ServerLevel pLevel, EntityMaid maid, long pGameTime) {
        BlockPos.MutableBlockPos currentPosition = maid.m_20183_().m_122032_();
        Vec3 centerPos = Vec3.m_82512_((Vec3i)currentPosition);
        maid.m_6027_(centerPos.f_82479_, currentPosition.m_123342_(), centerPos.f_82481_);
        maid.m_20334_(0.0, maid.m_20184_().m_7098_(), 0.0);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, EntityMaid maid) {
        if (!maid.getConfigManager().isActiveClimbing()) {
            return false;
        }
        return maid.m_6147_();
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void tick(ServerLevel level, EntityMaid maid, long pGameTime) {
        Node pointNext;
        Path path = maid.m_21573_().m_26570_();
        if (path == null || path.m_77392_()) {
            maid.setCanClimb(false);
            return;
        }
        maid.setCanClimb(true);
        int beGoNodeIndex = path.m_77399_();
        Node beGoNode = path.m_77375_(beGoNodeIndex);
        BlockPos maidFeetPos = maid.m_20183_();
        BlockState feetBlock = level.m_8055_(maidFeetPos);
        boolean up = true;
        if (beGoNodeIndex > 0) {
            Node currentNext = path.m_77375_(beGoNodeIndex - 1);
            pointNext = path.m_77375_(beGoNodeIndex);
            if (pointNext.f_77272_ <= currentNext.f_77272_) {
                up = false;
            }
        }
        maid.m_20260_(!up);
        if (maidFeetPos.m_123342_() <= beGoNode.f_77272_ && up && feetBlock.isLadder((LevelReader)level, maidFeetPos, (LivingEntity)maid)) {
            yMotion0 = 1.0;
            yMotion = 0.25;
            maid.m_20334_(0.0, yMotion0, 0.0);
            maid.m_20334_(0.0, yMotion, 0.0);
        } else {
            yMotion0 = -1.0;
            yMotion = -0.25;
            maid.m_20334_(0.0, yMotion0, 0.0);
            maid.m_20334_(0.0, yMotion, 0.0);
        }
        if (!up && beGoNode.f_77272_ != maidFeetPos.m_123342_()) {
            int nodeCount = path.m_77398_();
            for (int i1 = 0; i1 < nodeCount; ++i1) {
                Node node = path.m_77375_(i1);
                Node nextNode = path.m_77375_(Math.min(i1 + 1, nodeCount - 1));
                if (node.f_77272_ != maidFeetPos.m_123342_() || node.f_77271_ != maidFeetPos.m_123341_() || node.f_77273_ != maidFeetPos.m_123343_() || node.f_77272_ != nextNode.f_77272_) continue;
                beGoNodeIndex = i1;
                beGoNode = node;
                path.m_77393_(i1);
                break;
            }
        }
        if (beGoNode.f_77272_ - maidFeetPos.m_123342_() >= 0 && (double)(beGoNode.f_77272_ - maidFeetPos.m_123342_()) <= 1.2 && beGoNodeIndex + 1 < path.m_77398_()) {
            boolean beWalkSurface;
            Node currentNext = path.m_77375_(beGoNodeIndex);
            pointNext = path.m_77375_(beGoNodeIndex + 1);
            boolean bl = beWalkSurface = pointNext.f_77272_ == currentNext.f_77272_;
            if (beWalkSurface || pointNext == path.m_77395_() || maidFeetPos.m_123342_() == currentNext.f_77272_) {
                maid.setCanClimb(false);
                int x1 = pointNext.f_77271_ - currentNext.f_77271_;
                int z1 = pointNext.f_77273_ - currentNext.f_77273_;
                double y = maid.m_20184_().m_7098_();
                maid.m_20334_(0.2, 1.0, 0.2);
                maid.m_20334_((double)x1 * 0.3, y + 0.012, (double)z1 * 0.3);
                maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pointNext.m_164701_()));
            }
        }
    }

    protected void stop(ServerLevel pLevel, EntityMaid maid, long pGameTime) {
        maid.m_20260_(false);
        maid.setCanClimb(false);
    }
}

