/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.ysm;

import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class YsmCompat {
    private static final String MOD_ID = "yes_steve_model";
    private static final VersionRange VERSION_RANGE;
    private static boolean INSTALLED;

    public static void init() {
        ModList.get().getModContainerById(MOD_ID).ifPresent(modContainer -> {
            ArtifactVersion version = modContainer.getModInfo().getVersion();
            INSTALLED = VERSION_RANGE.containsVersion(version) ? true : !FMLEnvironment.production;
        });
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }

    public static YsmMaidInfo getYsmMaidInfo(CompoundTag maidData) {
        if (YsmCompat.isInstalled()) {
            boolean isYsmModel = maidData.m_128471_("IsYsmModel");
            String ysmModelId = maidData.m_128461_("YsmModelId");
            String ysmTextureId = maidData.m_128461_("YsmModelTexture");
            String ysmName = maidData.m_128461_("YsmModelName");
            return new YsmMaidInfo(isYsmModel, ysmModelId, ysmTextureId, Component.Serializer.m_130701_((String)ysmName));
        }
        return YsmMaidInfo.EMPTY;
    }

    static {
        INSTALLED = false;
        try {
            VERSION_RANGE = VersionRange.createFromVersionSpec((String)"[2.3.3,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }
}

