/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidWalkToLivingEntityTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WalkToLivingEntityTaskJS
implements IMaidTask {
    private final Builder builder;

    public WalkToLivingEntityTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public ResourceLocation getUid() {
        return this.builder.id;
    }

    @Override
    public ItemStack getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidWalkToLivingEntityTask task = new MaidWalkToLivingEntityTask(0.6f, this.builder.closeEnoughDist, this.builder.startSearchPredicate, this.builder.entityPredicate, this.builder.arriveAction);
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)task))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    public static class Builder
    extends TaskBuilder<Builder, WalkToLivingEntityTaskJS> {
        @Nullable
        private Predicate<EntityMaid> startSearchPredicate = null;
        @Nullable
        private BiPredicate<EntityMaid, LivingEntity> entityPredicate = null;
        @Nullable
        private BiConsumer<EntityMaid, LivingEntity> arriveAction = null;
        private float closeEnoughDist = 2.0f;

        public Builder(ResourceLocation id, ItemStack icon) {
            super(id, icon);
        }

        @Info(value="Mandatory, this is the condition to check before starting the entity search. <br>\nPlease only perform the search when necessary to reduce performance overhead. <br>\n\u5fc5\u586b\u9879\u76ee\uff0c\u5f00\u59cb\u8fdb\u884c\u5b9e\u4f53\u641c\u7d22\u4e4b\u524d\u7684\u5224\u65ad\u6761\u4ef6\uff0c\u8bf7\u5728\u5fc5\u8981\u65f6\u518d\u8fdb\u884c\u641c\u7d22\uff0c\u51cf\u5c11\u6027\u80fd\u6d88\u8017\n")
        public Builder setStartSearchPredicate(Predicate<EntityMaid> predicate) {
            this.startSearchPredicate = predicate;
            return this;
        }

        @Info(value="Mandatory, this is the condition to check whether the entity is suitable for walking to. <br>\n\u5fc5\u586b\u9879\u76ee\uff0c\u641c\u7d22\u7684\u5b9e\u4f53\u662f\u5426\u662f\u6211\u4eec\u7684\u76ee\u6807\u5b9e\u4f53\n")
        public Builder setEntityPredicate(BiPredicate<EntityMaid, LivingEntity> predicate) {
            this.entityPredicate = predicate;
            return this;
        }

        @Info(value="Lastly, this is the logic to execute when arriving near the entity. Mandatory, otherwise no logic will be executed. <br>\n\u6700\u540e\u5230\u8fbe\u5b9e\u4f53\u9644\u8fd1\u9700\u8981\u6267\u884c\u7684\u903b\u8f91\uff0c\u5fc5\u586b\u5185\u5bb9\uff0c\u5426\u5219\u4e0d\u6267\u884c\u4efb\u4f55\u903b\u8f91\n")
        public Builder setArriveAction(BiConsumer<EntityMaid, LivingEntity> action) {
            this.arriveAction = action;
            return this;
        }

        @Info(value="Optional, default is 2. The logic will only be executed if the distance to the target entity is less than or equal to this number of blocks. <br>\n\u9009\u586b\u5185\u5bb9\uff0c\u9ed8\u8ba4\u4e3a 2\u3002\u5f53\u8ddd\u79bb\u76ee\u6807\u5b9e\u4f53\u5c0f\u4e8e\u7b49\u4e8e\u8fd9\u91cc\u7684\u683c\u6570\u65f6\u624d\u4f1a\u6267\u884c\u540e\u7eed\u903b\u8f91\n")
        public Builder setCloseEnoughDist(float dist) {
            this.closeEnoughDist = dist;
            return this;
        }
    }
}

