/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.sound.data;

import com.github.tartaricacid.touhoulittlemaid.util.OpusDecoderUtil;
import io.github.jaredmdobson.concentus.OpusException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;

public class OpusAudioStream
implements AudioStream {
    private final InputStream stream;
    private final AudioFormat format;
    private final int frameSize;
    private final byte[] frame;

    public OpusAudioStream(byte[] data) throws IOException, OpusException {
        Pair<AudioFormat, byte[]> decoded = OpusDecoderUtil.decode(data);
        this.stream = new ByteArrayInputStream((byte[])decoded.getRight());
        this.format = (AudioFormat)decoded.getLeft();
        this.frameSize = this.format.getFrameSize();
        this.frame = new byte[this.frameSize];
    }

    public AudioFormat m_6206_() {
        return this.format;
    }

    public ByteBuffer m_7118_(int size) throws IOException {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)size);
        int bytesRead = 0;
        int count = 0;
        do {
            if ((count = this.stream.read(this.frame)) == -1) continue;
            byteBuffer.put(this.frame);
        } while (count != -1 && (bytesRead += this.frameSize) < size);
        byteBuffer.flip();
        return byteBuffer;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

