/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.sound;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import com.github.tartaricacid.touhoulittlemaid.util.OpusDecoderUtil;
import com.mojang.blaze3d.audio.OggAudioStream;
import io.github.jaredmdobson.concentus.OpusException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.lwjgl.BufferUtils;

public final class OggReader {
    public static void readSoundDataFromFile(File file, List<SoundData> sounds, Marker marker) {
        Path path = file.toPath();
        try {
            block17: {
                Type type = OggReader.getOggType(path);
                if (type == Type.VORBIS) {
                    try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                         OggAudioStream audioStream = new OggAudioStream(stream);){
                        ByteBuffer bytebuffer = audioStream.m_83764_();
                        sounds.add(new SoundData(bytebuffer, audioStream.m_6206_()));
                        break block17;
                    }
                }
                if (type == Type.OPUS) {
                    byte[] input = FileUtils.readFileToByteArray((File)file);
                    try {
                        Pair<AudioFormat, byte[]> output = OpusDecoderUtil.decode(input);
                        byte[] pcm = (byte[])output.getRight();
                        ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)pcm.length);
                        bytebuffer.put(pcm);
                        bytebuffer.flip();
                        sounds.add(new SoundData(bytebuffer, (AudioFormat)output.getLeft()));
                    }
                    catch (OpusException e) {
                        TouhouLittleMaid.LOGGER.error("Error decoding opus file: {}", (Object)file.getName(), (Object)e);
                    }
                }
            }
            TouhouLittleMaid.LOGGER.debug(marker, "sound: {}", (Object)file.getName());
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Error reading sound file: {}", (Object)path, (Object)e);
        }
    }

    public static void readSoundDataFromZip(ZipFile zipFile, ZipEntry zipEntry, String fileName, List<SoundData> sounds, Marker marker) {
        try {
            block23: {
                Type type = OggReader.getOggType(zipFile, zipEntry);
                if (type == Type.VORBIS) {
                    try (InputStream stream = zipFile.getInputStream(zipEntry);
                         OggAudioStream audioStream = new OggAudioStream(stream);){
                        ByteBuffer bytebuffer = audioStream.m_83764_();
                        sounds.add(new SoundData(bytebuffer, audioStream.m_6206_()));
                        break block23;
                    }
                }
                if (type == Type.OPUS) {
                    try (InputStream stream = zipFile.getInputStream(zipEntry);){
                        byte[] input = IOUtils.toByteArray((InputStream)stream);
                        Pair<AudioFormat, byte[]> output = OpusDecoderUtil.decode(input);
                        byte[] pcm = (byte[])output.getRight();
                        ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)pcm.length);
                        bytebuffer.put(pcm);
                        bytebuffer.flip();
                        sounds.add(new SoundData(bytebuffer, (AudioFormat)output.getLeft()));
                    }
                    catch (OpusException e) {
                        TouhouLittleMaid.LOGGER.error("Error decoding opus file: {}", (Object)fileName, (Object)e);
                    }
                }
            }
            TouhouLittleMaid.LOGGER.debug(marker, "sound: {}", (Object)fileName);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Error reading sound file: {}", (Object)fileName, (Object)e);
        }
    }

    private static Type getOggType(Path filePath) throws IOException {
        try (InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);){
            Type type = OggReader.getOggType(stream);
            return type;
        }
    }

    private static Type getOggType(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (InputStream stream = zipFile.getInputStream(zipEntry);){
            Type type = OggReader.getOggType(stream);
            return type;
        }
    }

    public static Type getOggType(byte[] data) throws IOException {
        return OggReader.getOggType(new ByteArrayInputStream(data));
    }

    private static Type getOggType(InputStream stream) throws IOException {
        try (OggFile oggFile = new OggFile(stream);){
            OggStreamIdentifier.OggStreamType streamType = OggStreamIdentifier.identifyType((OggPacket)oggFile.getPacketReader().getNextPacket());
            if (streamType == OggStreamIdentifier.OGG_VORBIS) {
                Type type = Type.VORBIS;
                return type;
            }
            if (streamType == OggStreamIdentifier.OPUS_AUDIO || streamType == OggStreamIdentifier.OPUS_AUDIO_ALT) {
                Type type = Type.OPUS;
                return type;
            }
            Type type = Type.UNKNOWN;
            return type;
        }
    }

    public static enum Type {
        VORBIS,
        OPUS,
        UNKNOWN;

    }
}

