/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.WChessPiecesModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityWChess;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityWChessRenderer
implements BlockEntityRenderer<TileEntityWChess> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/block/wchess.png");
    private static final ResourceLocation PIECES_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/block/wchess_pieces.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;
    private final SimpleBedrockModel<Entity> chessModel = BedrockModelLoader.getModel(BedrockModelLoader.WCHESS);
    private final WChessPiecesModel[] chessPiecesModels = WChessPiecesModel.initModel();
    private final WChessPiecesModel selectedModels = WChessPiecesModel.getSelectedModel();

    public TileEntityWChessRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.m_173581_();
        this.font = context.m_173586_();
    }

    public void render(TileEntityWChess cchess, float pPartialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)cchess.m_58900_().m_61143_((Property)BlockGomoku.FACING);
        this.renderChessboard(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderPiece(cchess, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderTipsText(cchess, poseStack, bufferIn, combinedLightIn);
    }

    private void renderTipsText(TileEntityWChess chess, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        boolean showTips;
        boolean bl = showTips = chess.isCheckmate() || chess.isRepeat() || chess.isMoveNumberLimit();
        if (!showTips || !this.inRenderDistance(chess, 16)) {
            return;
        }
        Camera camera = this.dispatcher.f_112249_;
        MutableComponent loseTips = null;
        MutableComponent resetTips = Component.m_237115_((String)"message.touhou_little_maid.wchess.reset").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.AQUA);
        MutableComponent roundText = Component.m_237110_((String)"message.touhou_little_maid.gomoku.round", (Object[])new Object[]{chess.getChessCounter()}).m_130940_(ChatFormatting.WHITE);
        MutableComponent preRoundIcon = Component.m_237113_((String)"\u23f9 ").m_130940_(ChatFormatting.GREEN);
        MutableComponent postRoundIcon = Component.m_237113_((String)" \u23f9").m_130940_(ChatFormatting.GREEN);
        MutableComponent roundTips = preRoundIcon.m_7220_((Component)roundText).m_7220_((Component)postRoundIcon);
        if (chess.isCheckmate()) {
            loseTips = !chess.isPlayerTurn() ? Component.m_237115_((String)"message.touhou_little_maid.gomoku.win").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE) : Component.m_237115_((String)"message.touhou_little_maid.gomoku.lose").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
        } else if (chess.isMoveNumberLimit()) {
            loseTips = Component.m_237115_((String)"message.touhou_little_maid.cchess.move_limit").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
        } else if (chess.isRepeat()) {
            loseTips = Component.m_237115_((String)"message.touhou_little_maid.cchess.repeat").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
        }
        if (loseTips == null) {
            return;
        }
        float loseTipsWidth = -this.font.m_92852_((FormattedText)loseTips) / 2;
        float resetTipsWidth = -this.font.m_92852_((FormattedText)resetTips) / 2;
        float roundTipsWidth = -this.font.m_92852_((FormattedText)roundTips) / 2;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.75, 0.5);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f + camera.m_90590_()));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(camera.m_90589_()));
        poseStack.m_85841_(0.03f, -0.03f, 0.03f);
        this.font.m_272077_((Component)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        this.font.m_272077_((Component)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        this.font.m_272077_((Component)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    private void renderPiece(TileEntityWChess cchess, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Direction facing) {
        if (this.inRenderDistance(cchess, 24)) {
            VertexConsumer piecesBuff = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)PIECES_TEXTURE));
            int selectX = Position.FILE_X(cchess.getSelectChessPoint());
            int selectY = Position.RANK_Y(cchess.getSelectChessPoint());
            byte[] data = cchess.getChessData().squares;
            poseStack.m_85836_();
            switch (facing) {
                case NORTH: {
                    poseStack.m_85837_(1.375, 1.625, 1.375);
                    break;
                }
                case EAST: {
                    poseStack.m_85837_(-0.375, 1.625, 1.375);
                    break;
                }
                case WEST: {
                    poseStack.m_85837_(1.375, 1.625, -0.375);
                    break;
                }
                default: {
                    poseStack.m_85837_(-0.375, 1.625, -0.375);
                }
            }
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(facing.m_122416_() * 90)));
            if (facing == Direction.SOUTH || facing == Direction.NORTH) {
                poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            }
            for (int y = 0; y <= 7; ++y) {
                for (int x = 4; x <= 11; ++x) {
                    byte piecesIndex = data[Position.COORD_XY(x, y)];
                    if (WChessUtil.isWhite(piecesIndex) || WChessUtil.isBlack(piecesIndex)) {
                        WChessPiecesModel chessPiecesModel = this.chessPiecesModels[piecesIndex];
                        chessPiecesModel.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        if (selectX == x && selectY == y) {
                            this.selectedModels.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    poseStack.m_85837_(0.25, 0.0, 0.0);
                }
                poseStack.m_85837_(-2.0, 0.0, -0.25);
            }
            poseStack.m_85849_();
        }
    }

    private void renderChessboard(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Direction facing) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(facing.m_122416_() * 90)));
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        }
        VertexConsumer checkerBoardBuff = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.chessModel.m_7695_(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private boolean inRenderDistance(TileEntityWChess chess, int distance) {
        BlockPos pos = chess.m_58899_();
        return this.dispatcher.f_112249_.m_90583_().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityWChess te) {
        return true;
    }
}

