/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TileEntityAltarRenderer
implements BlockEntityRenderer<TileEntityAltar> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/block/altar.png");
    private final SimpleBedrockModel<? extends Entity> model = BedrockModelLoader.getModel(BedrockModelLoader.ALTAR);

    public TileEntityAltarRenderer(BlockEntityRendererProvider.Context render) {
    }

    public void render(TileEntityAltar te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRender()) {
            poseStack.m_85836_();
            this.setTranslateAndPose(te, poseStack);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
            this.model.m_7695_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        if (te.isCanPlaceItem() && !te.handler.getStackInSlot(0).m_41619_()) {
            ItemStack stack = te.handler.getStackInSlot(0);
            poseStack.m_85836_();
            double time = (System.currentTimeMillis() + te.m_58899_().m_121878_()) % 3600L;
            poseStack.m_85837_(0.5, 1.25 + Math.sin(time / 1800.0 * Math.PI) * 0.1, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)time / 10.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, te.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(TileEntityAltar te) {
        return true;
    }

    private void setTranslateAndPose(TileEntityAltar te, PoseStack poseStack) {
        switch (te.getDirection()) {
            case SOUTH: {
                poseStack.m_85837_(1.0, -1.5, -3.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_85837_(-3.0, -1.5, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                poseStack.m_85837_(4.0, -1.5, 1.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            default: {
                poseStack.m_85837_(0.0, -1.5, 4.0);
            }
        }
    }
}

