/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task.MaidTaskConfigGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MonsterListButton;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetAttackListMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.registries.ForgeRegistries;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class AttackTaskConfigGui
extends MaidTaskConfigGui<TaskConfigContainer> {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/attack_task_config.png");
    private final Map<ResourceLocation, MonsterType> attackGroups = Objects.requireNonNullElse(this.getMaid().getData(InitTaskData.ATTACK_LIST), AttackListData.empty()).attackGroups();
    private final List<ResourceLocation> attackGroupsKey = Lists.newArrayList();
    private EditBox inputField;
    private int page = 0;

    public AttackTaskConfigGui(TaskConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.sortKey();
    }

    private void sortKey() {
        this.attackGroupsKey.clear();
        ArrayList hostile = Lists.newArrayList();
        ArrayList neutral = Lists.newArrayList();
        ArrayList friendly = Lists.newArrayList();
        for (ResourceLocation id : this.attackGroups.keySet()) {
            if (this.attackGroups.get(id) == MonsterType.HOSTILE) {
                hostile.add(id);
            }
            if (this.attackGroups.get(id) == MonsterType.NEUTRAL) {
                neutral.add(id);
            }
            if (this.attackGroups.get(id) != MonsterType.FRIENDLY) continue;
            friendly.add(id);
        }
        this.attackGroupsKey.addAll(hostile);
        this.attackGroupsKey.addAll(neutral);
        this.attackGroupsKey.addAll(friendly);
        this.page = Mth.m_14045_((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
    }

    @Override
    protected void initAdditionWidgets() {
        int startLeft = this.f_97735_ + 87;
        int startTop = this.f_97736_ + 36;
        this.inputField = new EditBox(this.f_96547_, startLeft, startTop, 117, 16, (Component)Component.m_237113_((String)"Monster List"));
        this.inputField.m_94199_(256);
        this.m_7787_((GuiEventListener)this.inputField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.touhou_little_maid.monster_type.add"), b -> this.addMonsterType()).m_252794_(startLeft + 119, startTop - 1).m_253046_(44, 18).m_253136_());
        this.m_142416_((GuiEventListener)new ImageButton(startLeft + 121, startTop + 20, 5, 9, 0, 176, 9, BG, b -> {
            --this.page;
            this.page = Mth.m_14045_((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new ImageButton(startLeft + 156, startTop + 20, 5, 9, 5, 176, 9, BG, b -> {
            ++this.page;
            this.page = Mth.m_14045_((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.m_7856_();
        }));
        for (int i = 0; i < 7; ++i) {
            int index = this.page * 7 + i;
            if (index >= this.attackGroupsKey.size()) {
                return;
            }
            ResourceLocation id = this.attackGroupsKey.get(index);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
            if (type == null) continue;
            Component name = type.m_20676_();
            int yOffset = startTop + 31 + 13 * i;
            this.m_142416_((GuiEventListener)new MonsterListButton(name, startLeft - 1, yOffset, id, this));
        }
    }

    private void addMonsterType() {
        String value = this.inputField.m_94155_();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!ResourceLocation.m_135830_((String)value)) {
            return;
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)value);
        if (ForgeRegistries.ENTITY_TYPES.containsKey(id)) {
            this.attackGroups.put(id, MonsterType.NEUTRAL);
            this.sortKey();
            super.m_7856_();
        }
    }

    public void removeMonsterType(ResourceLocation id) {
        this.attackGroups.remove(id);
        this.sortKey();
        super.m_7856_();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.inputField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.inputField.m_94144_(value);
    }

    @Override
    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.inputField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        MutableComponent pageText = Component.m_237113_((String)String.format("%d/%d", this.page + 1, (this.attackGroupsKey.size() - 1) / 7 + 1));
        graphics.m_280653_(this.f_96547_, (Component)pageText, this.f_97735_ + 228, this.f_97736_ + 57, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.monster_type.title"), this.f_97735_ + 147, this.f_97736_ + 57, 0xFFFFFF);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.inputField.m_94120_();
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        graphics.m_280218_(BG, this.f_97735_ + 80, this.f_97736_ + 28, 0, 0, this.f_97726_, 137);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.getMinecraft().f_91074_ != null) {
            this.getMinecraft().f_91074_.m_6915_();
        }
        return this.inputField.m_7933_(keyCode, scanCode, modifiers) || this.inputField.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_7379_() {
        NetworkHandler.CHANNEL.sendToServer((Object)new SetAttackListMessage(this.getMaid().m_19879_(), this.attackGroups));
        super.m_7379_();
    }

    public Map<ResourceLocation, MonsterType> getAttackGroups() {
        return this.attackGroups;
    }
}

