/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import com.github.tartaricacid.touhoulittlemaid.item.ItemServantBell;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class ScrollRenderEvent {
    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (RenderLevelStageEvent.Stage.AFTER_PARTICLES.equals(event.getStage()) && player != null) {
            Optional<Pair<String, BlockPos>> trackInfo = ScrollRenderEvent.getInfo((Player)player, player.m_21205_());
            if (trackInfo.isEmpty()) {
                return;
            }
            Pair<String, BlockPos> info = trackInfo.get();
            String dimension = (String)info.getLeft();
            Vec3 trackVec = new Vec3((double)((BlockPos)info.getRight()).m_123341_(), (double)((BlockPos)info.getRight()).m_123342_(), (double)((BlockPos)info.getRight()).m_123343_());
            if (!dimension.equals(player.f_19853_.m_46472_().m_135782_().toString())) {
                return;
            }
            Vec3 playerVec = player.m_20182_();
            double actualDistance = playerVec.m_82554_(trackVec);
            if (actualDistance < 5.0) {
                return;
            }
            double viewDistance = actualDistance;
            double maxRenderDistance = (Integer)mc.f_91066_.m_231984_().m_231551_() * 16;
            if (actualDistance > maxRenderDistance) {
                Vec3 delta = trackVec.m_82546_(playerVec).m_82541_();
                trackVec = playerVec.m_82520_(delta.f_82479_ * maxRenderDistance, delta.f_82480_ * maxRenderDistance, delta.f_82481_ * maxRenderDistance);
                viewDistance = maxRenderDistance;
            }
            float scale = 0.02f * (((float)viewDistance + 4.0f) / 3.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderHelper.renderFloatingText(event.getPoseStack(), Math.round(actualDistance) + " m", trackVec, 0xFF8800, scale, -17.0f);
            RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", trackVec, 0xFF0000, scale * 1.2f, -5.0f);
        }
    }

    private static Optional<Pair<String, BlockPos>> getInfo(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof ItemFoxScroll) {
            Pair<String, BlockPos> trackInfo = ItemFoxScroll.getTrackInfo(player.m_21205_());
            return Optional.ofNullable(trackInfo);
        }
        if (stack.m_150930_((Item)InitItems.SERVANT_BELL.get())) {
            Pair<String, BlockPos> maidShow = ItemServantBell.getMaidShow(stack);
            return Optional.ofNullable(maidShow);
        }
        return Optional.empty();
    }
}

