/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockAltar
extends Block
implements EntityBlock {
    public BlockAltar() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(2.0f, 2.0f).m_60955_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityAltar(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.getAltar((BlockGetter)worldIn, pos).filter(altar -> handIn == InteractionHand.MAIN_HAND).map(altar -> {
            if (player.m_6144_() || player.m_21205_().m_41619_()) {
                this.takeOutItem(worldIn, (TileEntityAltar)((Object)altar), player);
            } else {
                this.takeInOrCraft(worldIn, (TileEntityAltar)((Object)altar), player);
            }
            altar.refresh();
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }).orElse(super.m_6227_(state, worldIn, pos, player, handIn, hit));
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.getAltar((BlockGetter)worldIn, pos).ifPresent(altar -> {
                ItemStack stack = altar.handler.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    Block.m_49840_((Level)worldIn, (BlockPos)pos.m_7918_(0, 1, 0), (ItemStack)stack);
                }
            });
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_) {
            this.getAltar((BlockGetter)world, pos).ifPresent(altar -> this.restoreStorageBlock(world, pos, altar.getBlockPosList()));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            this.getAltar((BlockGetter)worldIn, pos).ifPresent(altar -> {
                this.restoreStorageBlock(worldIn, pos, altar.getBlockPosList());
                if (!player.m_7500_()) {
                    Block block = altar.getStorageState().m_60734_();
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)block));
                }
            });
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getAltar(world, pos).map(altar -> new ItemStack((ItemLike)altar.getStorageState().m_60734_())).orElse(super.getCloneItemStack(state, target, world, pos, player));
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                if (target instanceof BlockHitResult && world instanceof ClientLevel) {
                    BlockHitResult blockTarget = (BlockHitResult)target;
                    BlockPos pos = blockTarget.m_82425_();
                    ClientLevel clientLevel = (ClientLevel)world;
                    this.getAltar((BlockGetter)world, pos).ifPresent(altar -> this.crack(clientLevel, pos, altar.getStorageState(), blockTarget.m_82434_()));
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                this.getAltar((BlockGetter)world, pos).ifPresent(altar -> Minecraft.m_91087_().f_91061_.m_107355_(pos, altar.getStorageState()));
                return true;
            }

            private Optional<TileEntityAltar> getAltar(BlockGetter world, BlockPos pos) {
                BlockEntity te = world.m_7702_(pos);
                if (te instanceof TileEntityAltar) {
                    return Optional.of((TileEntityAltar)te);
                }
                return Optional.empty();
            }

            @OnlyIn(value=Dist.CLIENT)
            private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
                if (state.m_60799_() != RenderShape.INVISIBLE) {
                    int posX = pos.m_123341_();
                    int posY = pos.m_123342_();
                    int posZ = pos.m_123343_();
                    AABB aabb = state.m_60808_((BlockGetter)world, pos).m_83215_();
                    double x = (double)posX + world.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - 0.2) + 0.1 + aabb.f_82288_;
                    double y = (double)posY + world.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - 0.2) + 0.1 + aabb.f_82289_;
                    double z = (double)posZ + world.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - 0.2) + 0.1 + aabb.f_82290_;
                    if (side == Direction.DOWN) {
                        y = (double)posY + aabb.f_82289_ - 0.1;
                    }
                    if (side == Direction.UP) {
                        y = (double)posY + aabb.f_82292_ + 0.1;
                    }
                    if (side == Direction.NORTH) {
                        z = (double)posZ + aabb.f_82290_ - 0.1;
                    }
                    if (side == Direction.SOUTH) {
                        z = (double)posZ + aabb.f_82293_ + 0.1;
                    }
                    if (side == Direction.WEST) {
                        x = (double)posX + aabb.f_82288_ - 0.1;
                    }
                    if (side == Direction.EAST) {
                        x = (double)posX + aabb.f_82291_ + 0.1;
                    }
                    TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                    Minecraft.m_91087_().f_91061_.m_107344_(diggingParticle.updateSprite(state, pos).m_107268_(0.2f).m_6569_(0.6f));
                }
            }
        });
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getAltar((BlockGetter)world, pos).map(altar -> altar.getStorageState().m_60827_()).orElse(super.getSoundType(state, world, pos, entity));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private void restoreStorageBlock(Level worldIn, BlockPos currentPos, PosListData posList) {
        for (BlockPos storagePos : posList.getData()) {
            if (storagePos.equals((Object)currentPos)) continue;
            this.getAltar((BlockGetter)worldIn, storagePos).ifPresent(altar -> worldIn.m_7731_(storagePos, altar.getStorageState(), 3));
        }
        worldIn.m_5594_(null, currentPos, SoundEvents.f_11738_, SoundSource.BLOCKS, 1.5f, 1.0f);
    }

    private void takeOutItem(Level world, TileEntityAltar altar, Player player) {
        if (altar.isCanPlaceItem() && !altar.handler.getStackInSlot(0).m_41619_()) {
            ItemStack extractItem = altar.handler.extractItem(0, 1, false);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extractItem);
            world.m_5594_(null, altar.m_58899_(), SoundEvents.f_12016_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.altarCraft(world, altar, player);
        }
    }

    private void takeInOrCraft(Level world, TileEntityAltar altar, Player playerIn) {
        if (altar.isCanPlaceItem() && altar.handler.getStackInSlot(0).m_41619_()) {
            altar.handler.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)playerIn.m_21205_(), (int)1));
            if (!playerIn.m_7500_()) {
                playerIn.m_21205_().m_41774_(1);
            }
            world.m_5594_(null, altar.m_58899_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.altarCraft(world, altar, playerIn);
        }
    }

    private void altarCraft(Level world, TileEntityAltar altar, Player playerIn) {
        AltarRecipeInventory inv = new AltarRecipeInventory();
        List<BlockPos> posList = altar.getCanPlaceItemPosList().getData();
        for (int i = 0; i < posList.size(); ++i) {
            BlockEntity te = world.m_7702_(posList.get(i));
            if (!(te instanceof TileEntityAltar)) continue;
            inv.m_6836_(i, ((TileEntityAltar)te).getStorageItem());
        }
        if (inv.m_7983_()) {
            return;
        }
        playerIn.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> world.m_7465_().m_44015_(InitRecipes.ALTAR_CRAFTING, (Container)inv, world).ifPresent(recipe -> this.spawnResultEntity(world, playerIn, (PowerCapability)power, (AltarRecipe)recipe, inv, altar)));
    }

    private Optional<TileEntityAltar> getAltar(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityAltar) {
            return Optional.of((TileEntityAltar)te);
        }
        return Optional.empty();
    }

    private void spawnResultEntity(Level world, Player playerIn, PowerCapability power, AltarRecipe altarRecipe, AltarRecipeInventory inventory, TileEntityAltar altar) {
        if (power.get() >= altarRecipe.getPowerCost()) {
            power.min(altarRecipe.getPowerCost());
            BlockPos centrePos = this.getCentrePos(altar.getBlockPosList(), altar.m_58899_());
            if (world instanceof ServerLevel) {
                altarRecipe.spawnOutputEntity((ServerLevel)world, centrePos.m_6630_(2), inventory);
            }
            this.removeAllAltarItem(world, altar);
            this.spawnParticleInCentre(world, centrePos);
            world.m_5594_(null, centrePos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundSource.VOICE, 1.0f, 1.0f);
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                InitTrigger.ALTAR_CRAFT.trigger(serverPlayer, altarRecipe.m_6423_());
            }
        } else if (!world.f_46443_) {
            playerIn.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.altar.not_enough_power"));
        }
    }

    private BlockPos getCentrePos(PosListData posList, BlockPos posClick) {
        int x = 0;
        int y = posClick.m_123342_() - 2;
        int z = 0;
        for (BlockPos pos : posList.getData()) {
            if (pos.m_123342_() != y) continue;
            x += pos.m_123341_();
            z += pos.m_123343_();
        }
        return new BlockPos(x / 8, y, z / 8);
    }

    private void removeAllAltarItem(Level world, TileEntityAltar altar) {
        for (BlockPos pos : altar.getCanPlaceItemPosList().getData()) {
            this.getAltar((BlockGetter)world, pos).ifPresent(te -> {
                te.handler.setStackInSlot(0, ItemStack.f_41583_);
                te.refresh();
                this.spawnParticleInCentre(world, te.m_58899_());
            });
        }
    }

    private void spawnParticleInCentre(Level world, BlockPos centrePos) {
        boolean width = true;
        boolean height = true;
        for (int i = 0; i < 5; ++i) {
            double xSpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            double ySpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            double zSpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)centrePos.m_123341_() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.m_123342_() + IMaidBauble.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.m_123343_() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)centrePos.m_123341_() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.m_123342_() + IMaidBauble.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.m_123343_() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
        }
    }
}

