/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.chess;

import java.io.IOException;
import java.io.InputStream;

public class Util {
    private static byte[] POP_COUNT_16 = new byte[65536];
    private static final int[] SHELL_STEP;

    public static int MIN_MAX(int min, int mid, int max) {
        return mid < min ? min : (mid > max ? max : mid);
    }

    public static int POP_COUNT_16(int data) {
        return POP_COUNT_16[data];
    }

    public static int readShort(InputStream in) throws IOException {
        int b0 = in.read();
        int b1 = in.read();
        if (b0 == -1 || b1 == -1) {
            throw new IOException();
        }
        return b0 | b1 << 8;
    }

    public static int readInt(InputStream in) throws IOException {
        int b0 = in.read();
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw new IOException();
        }
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    public static int binarySearch(int vl, int[] vls, int from, int to) {
        int low = from;
        int high = to - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (vls[mid] < vl) {
                low = mid + 1;
                continue;
            }
            if (vls[mid] > vl) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static void shellSort(int[] mvs, int[] vls, int from, int to) {
        int stepLevel = 1;
        while (SHELL_STEP[stepLevel] < to - from) {
            ++stepLevel;
        }
        --stepLevel;
        while (stepLevel > 0) {
            int step = SHELL_STEP[stepLevel];
            for (int i = from + step; i < to; ++i) {
                int mvBest = mvs[i];
                int vlBest = vls[i];
                for (int j = i - step; j >= from && vlBest > vls[j]; j -= step) {
                    mvs[j + step] = mvs[j];
                    vls[j + step] = vls[j];
                }
                mvs[j + step] = mvBest;
                vls[j + step] = vlBest;
            }
            --stepLevel;
        }
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            int n = (i >> 1 & 0x5555) + (i & 0x5555);
            n = (n >> 2 & 0x3333) + (n & 0x3333);
            n = (n >> 4 & 0xF0F) + (n & 0xF0F);
            Util.POP_COUNT_16[i] = (byte)((n >> 8) + (n & 0xFF));
        }
        SHELL_STEP = new int[]{0, 1, 4, 13, 40, 121, 364, 1093};
    }

    public static class RC4 {
        public int[] state = new int[256];
        public int x = 0;
        public int y = 0;

        public void swap(int i, int j) {
            int t = this.state[i];
            this.state[i] = this.state[j];
            this.state[j] = t;
        }

        public RC4(byte[] key) {
            for (int i = 0; i < 256; ++i) {
                this.state[i] = i;
            }
            int j = 0;
            for (int i = 0; i < 256; ++i) {
                j = j + this.state[i] + key[i % key.length] & 0xFF;
                this.swap(i, j);
            }
        }

        public int nextByte() {
            this.x = this.x + 1 & 0xFF;
            this.y = this.y + this.state[this.x] & 0xFF;
            this.swap(this.x, this.y);
            int t = this.state[this.x] + this.state[this.y] & 0xFF;
            return this.state[t];
        }

        public int nextLong() {
            int n0 = this.nextByte();
            int n1 = this.nextByte();
            int n2 = this.nextByte();
            int n3 = this.nextByte();
            return n0 + (n1 << 8) + (n2 << 16) + (n3 << 24);
        }
    }
}

