/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.FunctionCallRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.FunctionTool;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.ChatType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.LLMOpenAISite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.ResponseFormat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.Tool;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.ChatCompletionResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.Message;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.Usage;
import com.github.tartaricacid.touhoulittlemaid.capability.ChatTokensCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.net.MediaType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.StringUtils;

public final class LLMOpenAIClient
implements LLMClient {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(60L);
    private final HttpClient httpClient;
    private final LLMOpenAISite site;

    public LLMOpenAIClient(HttpClient httpClient, LLMOpenAISite site) {
        this.httpClient = httpClient;
        this.site = site;
    }

    @Override
    public void chat(List<LLMMessage> messages, LLMConfig config, ResponseCallback<ResponseChat> callback) {
        URI url = URI.create(this.site.url());
        String apiKey = this.site.secretKey();
        String model = config.model();
        double temperature = config.temperature();
        int maxTokens = config.maxTokens();
        EntityMaid maid = config.maid();
        ChatType chatType = config.chatType();
        ChatCompletion chatCompletion = ChatCompletion.create().model(model).maxTokens(maxTokens).temperature(temperature).setResponseFormat(ResponseFormat.text());
        for (LLMMessage message : messages) {
            if (message.role() == Role.USER) {
                chatCompletion.userChat(message.message());
                continue;
            }
            if (message.role() == Role.ASSISTANT) {
                if (message.toolCalls() == null || message.toolCalls().isEmpty()) {
                    chatCompletion.assistantChat(message.message());
                    continue;
                }
                chatCompletion.assistantChat(message.message(), message.toolCalls());
                continue;
            }
            if (message.role() == Role.SYSTEM) {
                chatCompletion.systemChat(message.message());
                continue;
            }
            if (message.role() != Role.TOOL) continue;
            chatCompletion.toolChat(message.message(), message.toolCallId());
        }
        if (((Boolean)AIConfig.FUNCTION_CALL_ENABLED.get()).booleanValue() && chatType != ChatType.AUTO_GEN_SETTING) {
            this.addFunctionCalls(maid, chatCompletion);
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatCompletion))).timeout(MAX_TIMEOUT).uri(url);
        if (TouhouLittleMaid.DEBUG) {
            TouhouLittleMaid.LOGGER.info(GSON.toJson((Object)chatCompletion));
        }
        this.site.headers().forEach(builder::header);
        HttpRequest httpRequest = builder.build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).whenComplete((response, throwable) -> this.handle(messages, config, callback, (HttpResponse<String>)response, (Throwable)throwable, httpRequest));
    }

    private void addFunctionCalls(EntityMaid maid, ChatCompletion chatCompletion) {
        FunctionCallRegister.getFunctionCalls().forEach((key, value) -> {
            if (!value.addToChatCompletion(maid, chatCompletion)) {
                return;
            }
            String id = value.getId();
            String description = value.getDescription(maid);
            ObjectParameter root = ObjectParameter.create();
            Parameter parameter = value.addParameters(root, maid);
            Tool tool = FunctionTool.create().setName(id).setDescription(description).setParameters(parameter).build();
            chatCompletion.addTool(tool);
        });
    }

    private void handle(List<LLMMessage> messages, LLMConfig config, ResponseCallback<ResponseChat> callback, HttpResponse<String> response, Throwable throwable, HttpRequest request) {
        this.handleResponse(callback, response, throwable, request, chat -> {
            Message firstChoice;
            LivingEntity patt6223$temp;
            int totalTokens;
            Usage usage;
            if (TouhouLittleMaid.DEBUG) {
                TouhouLittleMaid.LOGGER.info(GSON.toJson(chat));
            }
            if ((usage = chat.getUsage()) != null && (totalTokens = usage.getTotalTokens()) > 0 && (patt6223$temp = config.maid().m_269323_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt6223$temp;
                serverPlayer.getCapability(ChatTokensCapabilityProvider.CHAT_TOKENS_CAP).ifPresent(tokens -> tokens.addCount(totalTokens));
            }
            if ((firstChoice = chat.getFirstChoice()) == null) {
                String message = "No Choice Found: %s".formatted(response);
                callback.onFailure(request, new Throwable(message), 3);
                return;
            }
            if (firstChoice.hasToolCall()) {
                ((LLMCallback)callback).onFunctionCall(firstChoice, messages, config, this);
            } else {
                this.onTextCall(callback, firstChoice);
            }
        }, (Type)((Object)ChatCompletionResponse.class));
    }

    private void onTextCall(ResponseCallback<ResponseChat> callback, Message firstChoice) {
        String content = firstChoice.getContent();
        if (StringUtils.isBlank((CharSequence)content)) {
            callback.onSuccess(new ResponseChat("", ""));
            return;
        }
        callback.onSuccess(new ResponseChat(content));
    }
}

