/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.ChatClientInfo;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatMessage;
import java.net.http.HttpRequest;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class STTCallback
implements ResponseCallback<String> {
    private final Player player;
    private final EntityMaid maid;

    public STTCallback(Player player, EntityMaid maid) {
        this.player = player;
        this.maid = maid;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        String cause = throwable.getLocalizedMessage();
        MutableComponent errorMessage = ErrorCode.getErrorMessage(ServiceType.STT, errorCode, cause);
        this.player.m_213846_((Component)errorMessage.m_130940_(ChatFormatting.RED));
        TouhouLittleMaid.LOGGER.error("STT request failed: {}, error is {}", (Object)request, (Object)throwable.getMessage());
    }

    @Override
    public void onSuccess(String chatText) {
        if (StringUtils.isNotBlank((CharSequence)chatText)) {
            ChatClientInfo clientInfo = ChatClientInfo.fromMaid(this.maid);
            NetworkHandler.CHANNEL.sendToServer((Object)new SendUserChatMessage(this.maid.m_19879_(), chatText, clientInfo));
            String name = this.player.m_6302_();
            String format = String.format("<%s> %s", name, chatText);
            this.player.m_213846_((Component)Component.m_237113_((String)format).m_130940_(ChatFormatting.GRAY));
        } else {
            MutableComponent component = Component.m_237115_((String)"ai.touhou_little_maid.chat.stt.content_is_empty");
            this.player.m_213846_((Component)component.m_130940_(ChatFormatting.GRAY));
        }
    }
}

