/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Player2AppCheck {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(15L);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(MAX_TIMEOUT).build();
    private static final HttpRequest REQUEST = HttpRequest.newBuilder().uri(URI.create("http://127.0.0.1:4315/v1/health")).header("Accept", MediaType.JSON_UTF_8.toString()).header("player2-game-key", "TouhouLittleMaid").timeout(MAX_TIMEOUT).GET().build();

    public static void checkPlayer2App(ServerPlayer player, Runnable runnable) {
        HTTP_CLIENT.sendAsync(REQUEST, HttpResponse.BodyHandlers.ofString()).whenComplete((response, exception) -> {
            if (exception != null) {
                Player2AppCheck.sendTip((Player)player);
                return;
            }
            if (response.statusCode() != 200) {
                player.m_213846_((Component)Component.m_237110_((String)"ai.touhou_little_maid.chat.player2_error", (Object[])new Object[]{response.statusCode()}));
                return;
            }
            if (player.m_20194_() != null) {
                player.m_20194_().m_18707_(runnable);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void checkPlayer2AppInStt(Player player, Runnable runnable) {
        HTTP_CLIENT.sendAsync(REQUEST, HttpResponse.BodyHandlers.ofString()).whenComplete((response, exception) -> {
            if (exception != null) {
                Player2AppCheck.sendTip(player);
                return;
            }
            if (response.statusCode() != 200) {
                player.m_213846_((Component)Component.m_237110_((String)"ai.touhou_little_maid.chat.player2_error", (Object[])new Object[]{response.statusCode()}));
                return;
            }
            Minecraft.m_91087_().m_18707_(runnable);
        });
    }

    private static void sendTip(Player player) {
        MutableComponent tip = Component.m_237115_((String)"ai.touhou_little_maid.chat.need_player2_install").m_130940_(ChatFormatting.RED);
        MutableComponent url = Component.m_237113_((String)"https://player2.game/");
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://player2.game/");
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.link.open"));
        url.m_130938_(style -> style.m_131144_(hoverEvent).m_131142_(clickEvent).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE));
        player.m_213846_((Component)tip);
        player.m_213846_((Component)Component.m_237115_((String)"ai.touhou_little_maid.chat.download_url").m_7220_((Component)url));
    }
}

