/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PLAYER_INVULNERABLE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_PLAYER_AMBIENT;
    public static final ForgeConfigSpec.ConfigValue<Double> HELLFIRE_DAMAGE_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Double> HELLCLOUD_DAMAGE_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Double> APOLLYON_HEALTH;
    public static final ForgeConfigSpec.ConfigValue<Double> APOLLYON_HURT_LIMIT;
    public static final ForgeConfigSpec.ConfigValue<Integer> SUMMON_APOLLYON_RANDOM_VALUE;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        PLAYER_INVULNERABLE = BUILDER.comment("Determines whether the player will be invincible when there is an Obsidian monolith, Default: true").define("player_invincible", true);
        ENABLE_PLAYER_AMBIENT = BUILDER.comment("Enable player ambient sound, Default: true").define("player_ambient_sound", true);
        HELLFIRE_DAMAGE_AMOUNT = BUILDER.comment("Sets the damage percentage Hellfire deals each time\uff0cDefault: 0.0444").define("hellfire_damage_amount", (Object)0.0444);
        HELLCLOUD_DAMAGE_AMOUNT = BUILDER.comment("Sets the damage percentage Hellcloud deals each time\uff0cDefault: 0.001").define("hellcloud_damage_amount", (Object)0.001);
        APOLLYON_HEALTH = BUILDER.comment("Sets the apollyon's health\uff0cDefault: 560").define("apollyon_health", (Object)560.0);
        APOLLYON_HURT_LIMIT = BUILDER.comment("Limit the amount of damage Apollyon takes each time. Default: 20.0").define("apollyon_hurt_limit", (Object)20.0);
        SUMMON_APOLLYON_RANDOM_VALUE = BUILDER.comment("The probability of summoning Apollyon during the ritual of summoning an apostle (Chance: 1 / value),").defineInRange("summon_apollyon_random_value", 100, 1, Integer.MAX_VALUE);
        BUILDER.push("General");
        SPEC = BUILDER.build();
    }
}

