/*
 * Decompiled with CFR 0.152.
 */
package cn.mcxkly.classicandsimplestatusbars.overlays;

import cn.mcxkly.classicandsimplestatusbars.ClassicAndSimpleStatusBars;
import cn.mcxkly.classicandsimplestatusbars.Config;
import cn.mcxkly.classicandsimplestatusbars.other.helper;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class HealthBar
implements IGuiOverlay {
    private static final ResourceLocation fullHealthBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/full.png");
    private static final ResourceLocation witherBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/wither.png");
    private static final ResourceLocation poisonBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/poison.png");
    private static final ResourceLocation frozenBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/frozen.png");
    private ResourceLocation currentBarLocation = fullHealthBarLocation;
    private static final ResourceLocation intermediateHealthBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/intermediate.png");
    private static final ResourceLocation emptyHealthBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/empty.png");
    private static final ResourceLocation absorptionBarLocation = new ResourceLocation("classicandsimplestatusbars", "textures/gui/healthbars/absorption.png");
    private static final ResourceLocation guiIconsLocation = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private float intermediateHealth = 0.0f;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        if (gui.shouldDrawSurvivalElements()) {
            Font font = gui.m_93082_();
            Player player = (Player)Minecraft.m_91087_().f_91075_;
            if (player == null) {
                return;
            }
            int x = width / 2 - 91;
            int y = height - 39;
            y += 4;
            if (Config.All_On && Config.Health_On) {
                this.updateBarTextures(player);
                this.renderHealthBar(guiGraphics, partialTick, x, y, player);
                this.renderHealthValue(font, guiGraphics, x, y, player);
            } else if (Config.EasyMode_Text_On) {
                this.renderHealthValue_Easy(font, guiGraphics, x, y, player);
            }
        }
    }

    private void renderHealthValue_Easy(Font font, GuiGraphics guiGraphics, int x, int y, Player player) {
        y -= 2;
        float MaxHealth = player.m_21233_();
        float Health = Math.min(player.m_21223_(), MaxHealth);
        float Absorption = player.m_6103_();
        int xx = x - 2;
        String text = helper.KeepOneDecimal(MaxHealth);
        guiGraphics.m_280056_(font, text, xx -= font.m_92895_(text), y - 1, Config.Color_Health, false);
        text = Config.Interval_lll;
        guiGraphics.m_280056_(font, text, xx -= font.m_92895_(text), y - 1, Config.Color_Interval_lll, false);
        if (Absorption > 0.0f) {
            text = helper.KeepOneDecimal(Absorption);
            guiGraphics.m_280056_(font, text, xx -= font.m_92895_(text), y - 1, Config.Color_Health_Absorb, false);
            text = Config.Interval_TTT;
            guiGraphics.m_280056_(font, text, xx -= font.m_92895_(text), y - 1, Config.Color_Interval_TTT, false);
        }
        text = helper.KeepOneDecimal(Health);
        guiGraphics.m_280056_(font, text, xx -= font.m_92895_(text), y - 1, Config.Color_Health_Tail, false);
    }

    public void updateBarTextures(Player player) {
        this.currentBarLocation = player.m_21023_(MobEffects.f_19615_) ? witherBarLocation : (player.m_21023_(MobEffects.f_19614_) ? poisonBarLocation : (player.m_146890_() ? frozenBarLocation : fullHealthBarLocation));
    }

    private void renderHealthValue(Font font, GuiGraphics guiGraphics, int x, int Y, Player player) {
        int y = Y + 1;
        int finalY = Y - 8;
        int finalX = x + 72;
        guiGraphics.m_280163_(guiIconsLocation, x, y - 10, 52.0f, 0.0f, 9, 9, 256, 256);
        float MaxHealth = player.m_21233_();
        float Health = Math.min(player.m_21223_(), MaxHealth);
        float Absorption = player.m_6103_();
        float ARMOR = player.m_21230_();
        int xx = x + 10;
        if (Absorption > 0.0f) {
            String text = helper.KeepOneDecimal(Health);
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Health, false);
            xx += font.m_92895_(text);
            text = Config.Interval_TTT;
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Interval_TTT, false);
            xx += font.m_92895_(text);
            text = helper.KeepOneDecimal(Absorption);
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Health_Absorb, false);
            xx += font.m_92895_(text);
            text = Config.Interval_lll;
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Interval_lll, false);
            xx += font.m_92895_(text);
            text = helper.KeepOneDecimal(MaxHealth);
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Health_Tail, false);
        } else {
            String text = helper.KeepOneDecimal(Health);
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Health, false);
            xx += font.m_92895_(text);
            text = Config.Interval_lll;
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Interval_lll, false);
            xx += font.m_92895_(text);
            text = helper.KeepOneDecimal(MaxHealth);
            guiGraphics.m_280056_(font, text, xx, y - 9, Config.Color_Health_Tail, false);
        }
        if (ARMOR > 0.0f && Config.Armour_On) {
            guiGraphics.m_280163_(guiIconsLocation, x, y - 19, 43.0f, 9.0f, 9, 9, 256, 256);
            guiGraphics.m_280056_(font, helper.KeepOneDecimal(ARMOR), x + 10, y - 19, Config.Color_Armor, false);
        }
        if (ClassicAndSimpleStatusBars.origins) {
            IPowerContainer.get((Entity)player).ifPresent(component -> {
                int iconSize = 8;
                List<ConfiguredPower> configuredPowers = component.getPowers().stream().map(Holder::m_203334_).filter(power -> power.asHudRendered().isPresent()).sorted(Comparator.comparing(power -> power.getRenderSettings((Entity)player).orElse(HudRender.DONT_RENDER).spriteLocation())).toList();
                for (ConfiguredPower hudPower : configuredPowers) {
                    HudRender render = hudPower.getRenderSettings((Entity)player).orElse(HudRender.DONT_RENDER);
                    if (!render.shouldRender(player) || !hudPower.shouldRender((Entity)player).orElse(false).booleanValue()) continue;
                    ResourceLocation currentLocation = render.spriteLocation();
                    int v = 8 + render.barIndex() * 10;
                    float fill = hudPower.getFill((Entity)player).orElse(Float.valueOf(0.0f)).floatValue();
                    if (render.isInverted()) {
                        fill = 1.0f - fill;
                    }
                    String tex = helper.KeepOneDecimal((int)(fill * 100.0f));
                    int finalY2 = finalY - 10;
                    guiGraphics.m_280056_(font, "%", finalX - font.m_92895_("%"), finalY2, Config.Color_Origins_Symbol, false);
                    guiGraphics.m_280056_(font, tex, finalX - font.m_92895_(tex) - font.m_92895_("%"), finalY2, Config.Color_Origins, false);
                    guiGraphics.m_280218_(currentLocation, finalX, finalY2, 73, v, iconSize, iconSize);
                }
            });
        }
    }

    private void renderHealthBar(GuiGraphics guiGraphics, float partialTick, int x, int y, Player player) {
        float maxHealth = player.m_21233_();
        float health = Math.min(player.m_21223_(), maxHealth);
        if (this.intermediateHealth > maxHealth) {
            this.intermediateHealth = maxHealth;
        }
        float intermediateProportion = health < this.intermediateHealth ? (this.intermediateHealth - health) / maxHealth : 0.0f;
        float healthProportion = health / maxHealth;
        int healthWidth = (int)Math.ceil(80.0f * healthProportion);
        int intermediateWidth = (int)Math.ceil(80.0f * intermediateProportion);
        guiGraphics.m_280163_(emptyHealthBarLocation, x + healthWidth + intermediateWidth, y, (float)(healthWidth + intermediateWidth), 0.0f, 80 - healthWidth - intermediateWidth, 5, 80, 5);
        guiGraphics.m_280163_(this.currentBarLocation, x, y, 0.0f, 0.0f, healthWidth, 5, 80, 5);
        float absorption = Math.min(player.m_6103_(), maxHealth);
        float absorptionProportion = absorption / maxHealth;
        if (absorptionProportion > 1.0f) {
            absorptionProportion = 1.0f;
        }
        int absorptionWidth = (int)Math.ceil(80.0f * absorptionProportion);
        if (absorption > 0.0f) {
            guiGraphics.m_280163_(absorptionBarLocation, x, y, 0.0f, 0.0f, absorptionWidth, 5, 80, 5);
        }
        int InsWidth = 0;
        float Inshealth = 0.0f;
        if (absorption > 0.0f) {
            InsWidth = absorptionWidth;
            Inshealth = absorption;
        } else {
            InsWidth = healthWidth;
            Inshealth = health;
        }
        guiGraphics.m_280163_(intermediateHealthBarLocation, x + InsWidth, y, (float)InsWidth, 0.0f, intermediateWidth, 5, 80, 5);
        this.intermediateHealth = (float)((double)this.intermediateHealth + (double)((Inshealth - this.intermediateHealth) * partialTick) * 0.08);
        if ((double)Math.abs(Inshealth - this.intermediateHealth) <= 0.25) {
            this.intermediateHealth = Inshealth;
        }
    }
}

