/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.client.handlers;

import auviotre.enigmatic.delicacy.contents.effects.RedemptionEffect;
import auviotre.enigmatic.delicacy.contents.items.AbyssalStew;
import auviotre.enigmatic.delicacy.contents.items.CursePotion;
import auviotre.enigmatic.delicacy.contents.items.CursedSoulCrystal;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.items.ForbiddenFruit;
import com.aizistral.enigmaticlegacy.objects.TransientPlayerData;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="enigmaticdelicacy")
public class ClientEventHandler {
    public static final ResourceLocation MC_ICONS = new ResourceLocation("textures/gui/icons.png");
    public static final ResourceLocation ICONS_LOCATION = new ResourceLocation("enigmaticdelicacy", "textures/gui/generic_icons.png");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        if (event.getEntity().m_21023_((MobEffect)EnigmaticDelightEffects.FADING_EFFECT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltipRendering(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderTooltipEvent.Color event) {
        Item item;
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && ((item = stack.m_41720_()) instanceof CursedSoulCrystal || item instanceof CursePotion)) {
            int background = -149942256;
            int borderStart = 1358892032;
            event.setBackground(background);
            event.setBorderStart(borderStart);
            event.setBorderEnd(borderStart);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderFireOverlay(RenderBlockScreenEffectEvent event) {
        Player player = event.getPlayer();
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && SuperpositionHandler.getPersistentInteger((Player)player, (String)"PopsicleNoFireTick", (int)0) > 0) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(receiveCanceled=true)
    public void onOverlayRender(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (event.getOverlay().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.type()) && AbyssalStew.barDisplay.getValue()) {
            if (!player.m_6084_()) {
                player.reviveCaps();
            }
            int abyssTick = AbyssalStew.getAbyssTick((Player)mc.f_91074_);
            if (player.m_7500_() || player.m_5833_() || abyssTick <= 0) {
                return;
            }
            TransientPlayerData data = TransientPlayerData.get((Player)player);
            if (data.getFireImmunityTimer() >= 0 && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BLAZING_CORE)) {
                return;
            }
            float partialTick = event.getPartialTick();
            float abyssPercent = ((float)(abyssTick + 1) - partialTick) / (float)AbyssalStew.duration.getValue();
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack pose = graphics.m_280168_();
            int x = event.getWindow().m_85445_() / 2 - 91;
            int xCorrection = 0;
            int yCorrection = 2;
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS_LOCATION);
            int length = (int)(abyssPercent * 183.0f);
            int l = event.getWindow().m_85446_() - 32 + 3;
            graphics.m_280163_(ICONS_LOCATION, x + xCorrection, l + yCorrection, 0.0f, 42.0f, 182, 3, 256, 256);
            if (length > 0) {
                graphics.m_280163_(ICONS_LOCATION, x + xCorrection, l + yCorrection, 0.0f, 45.0f, length, 3, 256, 256);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MC_ICONS);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(receiveCanceled=true)
    public void onOverlayRender(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (event.getOverlay().equals((Object)VanillaGuiOverlay.FOOD_LEVEL.type()) && RedemptionEffect.enable((Player)player)) {
            if (!ForbiddenFruit.renderHungerBar.getValue()) {
                event.setCanceled(true);
                return;
            }
            if (player.m_7500_() || player.m_5833_() || !ForbiddenFruit.replaceHungerBar.getValue()) {
                return;
            }
            event.setCanceled(true);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS_LOCATION);
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            int left = width / 2 + 91;
            int top = height - ((ForgeGui)Minecraft.m_91087_().f_91065_).rightHeight;
            ((ForgeGui)mc.f_91065_).rightHeight += 10;
            FoodData stats = player.m_36324_();
            int level = stats.m_38702_();
            int barPx = 8;
            int barNum = 10;
            for (int i = 0; i < barNum; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * barPx - 9;
                int y = top;
                int icon = 16;
                boolean background = false;
                if (player.m_36324_().m_38722_() <= 0.0f && mc.f_91065_.m_93079_() % (level * 3 + 1) == 0) {
                    y = top + (new Random().nextInt(3) - 1);
                }
                event.getGuiGraphics().m_280218_(ICONS_LOCATION, x - 1, y - 1, 0, 9, 11, 11);
                if (i * 2 + 1 < level) {
                    event.getGuiGraphics().m_280218_(ICONS_LOCATION, x, y, 0, 0, 9, 9);
                }
                if (i * 2 + 1 != level) continue;
                event.getGuiGraphics().m_280218_(ICONS_LOCATION, x, y, 9, 0, 9, 9);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MC_ICONS);
        }
    }
}

