/*
 * Decompiled with CFR 0.152.
 */
package com.mcmostwolf.enchantmentlib.jei;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class WrappedEnchantment
implements Comparable<WrappedEnchantment> {
    Enchantment ench;
    List<Enchantment> incompats = new ObjectArrayList();
    List<ItemStack> validItems = new ObjectArrayList();
    int pageIndex = 0;
    ExtendedButton left = new ExtendedButton(1, 68, 10, 10, (Component)Component.m_237113_((String)"<"), T -> {});
    ExtendedButton right = new ExtendedButton(54, 68, 10, 10, (Component)Component.m_237113_((String)">"), T -> {});

    public WrappedEnchantment(Enchantment ench, List<ItemStack> items) {
        this.ench = ench;
        for (Enchantment entry : ForgeRegistries.ENCHANTMENTS) {
            if (ench.m_44695_(entry) && entry.m_44695_(ench) || ench == entry) continue;
            this.incompats.add(entry);
        }
        int m = items.size();
        for (int i = 0; i < m; ++i) {
            ItemStack stack = items.get(i);
            if (!ench.canApplyAtEnchantingTable(stack)) continue;
            this.validItems.add(stack);
        }
    }

    public String toString() {
        return "Wrapped Enchantment: " + ForgeRegistries.ENCHANTMENTS.getKey((Object)this.ench).toString();
    }

    public String getDescription() {
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((Object)this.ench);
        String s = I18n.m_118938_((String)("enchantment." + id.m_135827_() + "." + id.m_135815_() + ".desc"), (Object[])new Object[0]);
        if (s.startsWith("enchantment.")) {
            return I18n.m_118938_((String)"unique.base.jei.no.description", (Object[])new Object[0]);
        }
        return s;
    }

    public ChatFormatting getFormatting(Enchantment.Rarity rarity) {
        switch (rarity) {
            case COMMON: {
                return ChatFormatting.WHITE;
            }
            case RARE: {
                return ChatFormatting.AQUA;
            }
            case UNCOMMON: {
                return ChatFormatting.YELLOW;
            }
            case VERY_RARE: {
                return ChatFormatting.LIGHT_PURPLE;
            }
        }
        return ChatFormatting.OBFUSCATED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<FormattedCharSequence> getIncompats(Font font) {
        ObjectArrayList list = new ObjectArrayList();
        if (this.incompats.isEmpty()) {
            list.addAll(font.m_92923_((FormattedText)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)"unique.base.jei.no.incompat")), 122));
        } else {
            for (Enchantment ench : this.incompats) {
                list.addAll(font.m_92923_((FormattedText)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ench.m_44704_())), 122));
            }
        }
        return list;
    }

    public String getName() {
        return I18n.m_118938_((String)this.ench.m_44704_(), (Object[])new Object[0]);
    }

    public Enchantment getEnchantment() {
        return this.ench;
    }

    @Override
    public int compareTo(WrappedEnchantment o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

