/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationAnd;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationOr;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public interface IRequirement
extends Predicate<CrockPotCookingRecipe.Wrapper> {
    public static IRequirement fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"requirement");
        RequirementType type = JsonUtils.getAsEnum(object, "type", RequirementType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RequirementType.CATEGORY_MAX -> RequirementCategoryMax.fromJson(object);
            case RequirementType.CATEGORY_MAX_EXCLUSIVE -> RequirementCategoryMaxExclusive.fromJson(object);
            case RequirementType.CATEGORY_MIN -> RequirementCategoryMin.fromJson(object);
            case RequirementType.CATEGORY_MIN_EXCLUSIVE -> RequirementCategoryMinExclusive.fromJson(object);
            case RequirementType.MUST_CONTAIN_INGREDIENT -> RequirementMustContainIngredient.fromJson(object);
            case RequirementType.MUST_CONTAIN_INGREDIENT_LESS_THAN -> RequirementMustContainIngredientLessThan.fromJson(object);
            case RequirementType.COMBINATION_AND -> RequirementCombinationAnd.fromJson(object);
            case RequirementType.COMBINATION_OR -> RequirementCombinationOr.fromJson(object);
        };
    }

    public JsonElement toJson();

    public static IRequirement fromNetwork(FriendlyByteBuf buffer) {
        RequirementType type = (RequirementType)buffer.m_130066_(RequirementType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RequirementType.CATEGORY_MAX -> RequirementCategoryMax.fromNetwork(buffer);
            case RequirementType.CATEGORY_MAX_EXCLUSIVE -> RequirementCategoryMaxExclusive.fromNetwork(buffer);
            case RequirementType.CATEGORY_MIN -> RequirementCategoryMin.fromNetwork(buffer);
            case RequirementType.CATEGORY_MIN_EXCLUSIVE -> RequirementCategoryMinExclusive.fromNetwork(buffer);
            case RequirementType.MUST_CONTAIN_INGREDIENT -> RequirementMustContainIngredient.fromNetwork(buffer);
            case RequirementType.MUST_CONTAIN_INGREDIENT_LESS_THAN -> RequirementMustContainIngredientLessThan.fromNetwork(buffer);
            case RequirementType.COMBINATION_AND -> RequirementCombinationAnd.fromNetwork(buffer);
            case RequirementType.COMBINATION_OR -> RequirementCombinationOr.fromNetwork(buffer);
        };
    }

    public void toNetwork(FriendlyByteBuf var1);
}

