/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.network;

import com.sihenzhang.crockpot.capability.FoodCounterCapabilityHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkEvent;

public class PacketFoodCounter {
    private final CompoundTag capabilityTag;

    public PacketFoodCounter(CompoundTag capabilityTag) {
        this.capabilityTag = capabilityTag;
    }

    public static void serialize(PacketFoodCounter pack, FriendlyByteBuf buf) {
        buf.m_130079_(pack.capabilityTag);
    }

    public static PacketFoodCounter deserialize(FriendlyByteBuf buf) {
        return new PacketFoodCounter(buf.m_130260_());
    }

    public static void handle(PacketFoodCounter pack, Supplier<NetworkEvent.Context> ctx) {
        if (EffectiveSide.get().isClient()) {
            Handler.handle(pack, ctx);
        }
    }

    private static class Handler {
        private Handler() {
        }

        static void handle(PacketFoodCounter pack, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.getCapability(FoodCounterCapabilityHandler.FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> foodCounter.deserializeNBT((Tag)pack.capabilityTag));
                }
            });
            context.setPacketHandled(true);
        }
    }
}

