/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.CrockPotConfigs;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.MathUtils;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CrockPotFoodProperties {
    private final FoodProperties foodProperties;
    final Item.Properties itemProperties;
    private final int duration;
    private final boolean isDrink;
    private final SoundEvent sound;
    private final int cooldown;
    private final float heal;
    private final Pair<ResourceKey<DamageType>, Float> damage;
    private final List<MobEffect> removedEffects;
    private final List<Component> tooltips;
    private final boolean hideEffects;
    private final List<Component> effectTooltips;

    public CrockPotFoodProperties(Builder builder) {
        this.foodProperties = builder.foodBuilder.m_38767_();
        this.itemProperties = builder.properties.m_41489_(this.foodProperties);
        this.duration = builder.duration;
        this.isDrink = builder.isDrink;
        this.sound = builder.sound;
        this.cooldown = builder.cooldown;
        this.heal = builder.heal;
        this.damage = builder.damage;
        this.removedEffects = List.copyOf(builder.removedEffects);
        this.tooltips = List.copyOf(builder.tooltips);
        this.hideEffects = builder.hideEffects;
        this.effectTooltips = List.copyOf(builder.effectTooltips);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int nutrition, float saturationModifier) {
        return new Builder(nutrition, saturationModifier);
    }

    public int getUseDuration() {
        return this.duration;
    }

    public UseAnim getUseAnimation() {
        return this.isDrink ? UseAnim.DRINK : UseAnim.EAT;
    }

    public SoundEvent getSound() {
        return this.sound == null ? (this.isDrink ? SoundEvents.f_11911_ : SoundEvents.f_11912_) : this.sound;
    }

    public void hurt(Level level, LivingEntity livingEntity) {
        if (!level.f_46443_ && this.damage != null) {
            ResourceKey damageTypeKey = (ResourceKey)this.damage.getFirst();
            level.m_9598_().m_6632_(Registries.f_268580_).flatMap(reg -> reg.m_203636_(damageTypeKey)).ifPresent(damageType -> livingEntity.m_6469_(new DamageSource((Holder)damageType), ((Float)this.damage.getSecond()).floatValue()));
        }
    }

    public void heal(Level level, LivingEntity livingEntity) {
        if (!level.f_46443_ && this.heal > 0.0f) {
            livingEntity.m_5634_(this.heal);
        }
    }

    public void removeEffects(Level level, LivingEntity livingEntity) {
        if (!level.f_46443_) {
            this.removedEffects.forEach(arg_0 -> ((LivingEntity)livingEntity).m_21195_(arg_0));
        }
    }

    public void addCooldown(Item item, Player player) {
        player.m_36335_().m_41524_(item, this.cooldown);
    }

    public List<Component> getTooltips() {
        return this.tooltips;
    }

    public List<Component> getEffectTooltips(boolean hasEaten) {
        float hearts;
        if (!((Boolean)CrockPotConfigs.SHOW_FOOD_EFFECTS_TOOLTIP.get()).booleanValue() || this.hideEffects) {
            return List.of();
        }
        if (!hasEaten) {
            return List.of(I18nUtils.createTooltipComponent("effect.not_eat").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        List effects = this.foodProperties.m_38749_();
        if (effects.isEmpty() && this.effectTooltips.isEmpty() && this.removedEffects.isEmpty() && this.heal <= 0.0f && (this.damage == null || ((Float)this.damage.getSecond()).floatValue() <= 0.0f)) {
            return List.of(I18nUtils.createTooltipComponent("effect.no_effect").m_130940_(ChatFormatting.DARK_GRAY));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        effects.forEach(p -> {
            Float probability;
            MobEffectInstance effect = (MobEffectInstance)p.getFirst();
            MutableComponent tooltip = Component.m_237115_((String)effect.m_19576_());
            if (effect.m_19564_() > 0) {
                tooltip = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{tooltip, Component.m_237115_((String)("potion.potency." + effect.m_19564_()))});
            }
            if (!effect.m_267633_(20)) {
                tooltip = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{tooltip, MobEffectUtil.m_267641_((MobEffectInstance)effect, (float)1.0f)});
            }
            if ((probability = (Float)p.getSecond()).floatValue() < 1.0f) {
                tooltip = I18nUtils.createTooltipComponent("effect.with_probability", StringUtils.format(probability.floatValue(), "0.##%"), tooltip);
            }
            builder.add((Object)tooltip.m_130940_(effect.m_19544_().m_19483_().m_19497_()));
        });
        if (!this.effectTooltips.isEmpty() || !this.removedEffects.isEmpty() || this.heal > 0.0f || this.damage != null && ((Float)this.damage.getSecond()).floatValue() > 0.0f) {
            builder.add((Object)Component.m_237119_());
            builder.add((Object)I18nUtils.createTooltipComponent("effect.when_" + (this.isDrink ? "drunk" : "eaten")).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        this.effectTooltips.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.removedEffects.forEach(e -> builder.add((Object)I18nUtils.createTooltipComponent("effect.remove", Component.m_237115_((String)e.m_19481_())).m_130940_(ChatFormatting.GOLD)));
        if (this.heal > 0.0f) {
            hearts = this.heal / 2.0f;
            builder.add((Object)I18nUtils.createTooltipComponent("effect.heal." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), StringUtils.format(hearts, "0.#")).m_130940_(ChatFormatting.BLUE));
        }
        if (this.damage != null && ((Float)this.damage.getSecond()).floatValue() > 0.0f) {
            hearts = ((Float)this.damage.getSecond()).floatValue() / 2.0f;
            builder.add((Object)I18nUtils.createTooltipComponent("effect.damage." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), StringUtils.format(hearts, "0.#")).m_130940_(ChatFormatting.RED));
        }
        return builder.build();
    }

    public static class Builder {
        Item.Properties properties = new Item.Properties();
        FoodProperties.Builder foodBuilder = new FoodProperties.Builder();
        int duration;
        boolean isDrink;
        SoundEvent sound;
        int cooldown;
        float heal;
        Pair<ResourceKey<DamageType>, Float> damage;
        final List<MobEffect> removedEffects;
        final List<Component> tooltips;
        boolean hideEffects;
        final List<Component> effectTooltips;

        public Builder() {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<MobEffect>();
            this.tooltips = new ArrayList<Component>();
            this.effectTooltips = new ArrayList<Component>();
        }

        public Builder(int nutrition, float saturationModifier) {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<MobEffect>();
            this.tooltips = new ArrayList<Component>();
            this.effectTooltips = new ArrayList<Component>();
            this.foodBuilder = this.foodBuilder.m_38760_(nutrition).m_38758_(saturationModifier);
        }

        public Builder nutrition(int nutrition) {
            this.foodBuilder = this.foodBuilder.m_38760_(nutrition);
            return this;
        }

        public Builder saturationMod(float saturationModifier) {
            this.foodBuilder = this.foodBuilder.m_38758_(saturationModifier);
            return this;
        }

        public Builder meat() {
            this.foodBuilder = this.foodBuilder.m_38757_();
            return this;
        }

        public Builder alwaysEat() {
            this.foodBuilder = this.foodBuilder.m_38765_();
            return this;
        }

        public Builder duration(FoodUseDuration duration) {
            this.duration = duration.val;
            return this;
        }

        public Builder effect(Supplier<MobEffectInstance> effect, float probability) {
            this.foodBuilder = this.foodBuilder.effect(effect, probability);
            return this;
        }

        public Builder effect(Supplier<MobEffectInstance> effect) {
            this.foodBuilder = this.foodBuilder.effect(effect, 1.0f);
            return this;
        }

        public Builder effect(MobEffect effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration, amplifier), probability);
        }

        public Builder effect(MobEffect effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public Builder effect(MobEffect effect, int duration, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration), probability);
        }

        public Builder effect(MobEffect effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public Builder effect(Supplier<? extends MobEffect> effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new MobEffectInstance((MobEffect)effect.get(), duration, amplifier), probability);
        }

        public Builder effect(Supplier<? extends MobEffect> effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public Builder effect(Supplier<? extends MobEffect> effect, int duration, float probability) {
            return this.effect(() -> new MobEffectInstance((MobEffect)effect.get(), duration), probability);
        }

        public Builder effect(Supplier<? extends MobEffect> effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public Builder drink() {
            this.isDrink = true;
            return this;
        }

        public Builder sound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder heal(float heal) {
            this.heal = heal;
            return this;
        }

        public Builder damage(ResourceKey<DamageType> damageSource, float damageAmount) {
            this.damage = Pair.of(damageSource, (Object)Float.valueOf(damageAmount));
            return this;
        }

        public Builder removeEffect(MobEffect effect) {
            this.removedEffects.add(effect);
            return this;
        }

        public Builder tooltip(String key) {
            this.tooltips.add((Component)I18nUtils.createTooltipComponent(key));
            return this;
        }

        public Builder tooltip(String key, ChatFormatting ... formats) {
            this.tooltips.add((Component)I18nUtils.createTooltipComponent(key).m_130944_(formats));
            return this;
        }

        public Builder hideEffects() {
            this.hideEffects = true;
            return this;
        }

        public Builder effectTooltip(Component tooltip) {
            this.effectTooltips.add(tooltip);
            return this;
        }

        public Builder effectTooltip(String key, ChatFormatting ... formats) {
            return this.effectTooltip((Component)I18nUtils.createTooltipComponent("effect." + key).m_130944_(formats));
        }

        public Builder effectTooltip(String key) {
            return this.effectTooltip((Component)I18nUtils.createTooltipComponent("effect." + key));
        }

        public Builder stacksTo(int maxStackSize) {
            this.properties = this.properties.m_41487_(maxStackSize);
            return this;
        }

        public Builder rarity(Rarity rarity) {
            this.properties = this.properties.m_41497_(rarity);
            return this;
        }

        public Builder craftRemainder(Item craftingRemainingItem) {
            this.properties = this.properties.m_41495_(craftingRemainingItem);
            return this;
        }

        public CrockPotFoodProperties build() {
            return new CrockPotFoodProperties(this);
        }
    }
}

