/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.theoneprobe;

import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.block.BirdcageBlock;
import com.sihenzhang.crockpot.block.entity.BirdcageBlockEntity;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.UsernameCache;

public class BirdcageProbeInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public ResourceLocation getID() {
        return RLUtils.createRL("birdcage");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
        Block block = blockState.m_60734_();
        if (block instanceof BirdcageBlock) {
            Parrot parrot;
            Object ownerUUID;
            BirdcageBlock birdcageBlock = (BirdcageBlock)block;
            BlockPos pos = data.getPos();
            BlockPos lowerPos = blockState.m_61143_(BirdcageBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
            List parrots = level.m_45976_(Parrot.class, new AABB((double)lowerPos.m_123341_(), (double)lowerPos.m_123342_(), (double)lowerPos.m_123343_(), (double)lowerPos.m_123341_() + 1.0, (double)lowerPos.m_123342_() + 2.0, (double)lowerPos.m_123343_() + 1.0));
            if (!parrots.isEmpty() && (ownerUUID = (parrot = (Parrot)parrots.get(0)).m_21805_()) != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerUUID);
                probeInfo.text((Component)I18nUtils.createIntegrationComponent("top", "owner", username == null ? "???" : username));
            }
            if ((ownerUUID = birdcageBlock.getBlockEntity((BlockGetter)level, pos, blockState)) instanceof BirdcageBlockEntity) {
                BirdcageBlockEntity birdcageBlockEntity = (BirdcageBlockEntity)((Object)ownerUUID);
                Queue<Pair<ItemStack, Long>> outputBuffer = birdcageBlockEntity.getOutputBuffer();
                for (Pair pair : outputBuffer) {
                    long remainTime = (Long)pair.getSecond() - level.m_46467_();
                    float progress = (float)(40L - remainTime) / 40.0f;
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item((ItemStack)pair.getFirst()).progress((int)(progress * 100.0f), 100, probeInfo.defaultProgressStyle().suffix((Component)Component.m_237113_((String)"%")));
                }
            }
        }
    }
}

