/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sihenzhang.crockpot.integration.jei.ModIntegrationJei;
import com.sihenzhang.crockpot.recipe.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.recipe.RangedItem;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class PiglinBarteringRecipeCategory
implements IRecipeCategory<PiglinBarteringRecipe> {
    public static final RecipeType<PiglinBarteringRecipe> RECIPE_TYPE = RecipeType.create((String)"crockpot", (String)"piglin_bartering", PiglinBarteringRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridFactory;

    public PiglinBarteringRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RLUtils.createRL("textures/gui/jei/piglin_bartering.png"), 0, 0, 177, 108);
        this.icon = guiHelper.createDrawable(ModIntegrationJei.ICONS, 32, 0, 16, 16);
        IScrollGridWidgetFactory scrollGridFactory = guiHelper.createScrollGridFactory(5, 6);
        scrollGridFactory.setPosition(70, 0);
        this.scrollGridFactory = scrollGridFactory;
    }

    public RecipeType<PiglinBarteringRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return I18nUtils.createIntegrationComponent("jei", "piglin_bartering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PiglinBarteringRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 1).setSlotName("inputSlot").addIngredients(recipe.getIngredient());
        int totalWeight = recipe.getWeightedResults().f_146324_;
        recipe.getWeightedResults().m_146338_().forEach(e -> {
            final RangedItem result = (RangedItem)e.m_146310_();
            final double chance = (double)e.m_142631_().m_146281_() / (double)totalWeight * 100.0;
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridFactory).addItemStack(result.item.m_7968_())).addTooltipCallback(new IRecipeSlotTooltipCallback(){

                public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
                    tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "output_chance", StringUtils.format(chance, "0.00")).m_130940_(ChatFormatting.GRAY));
                    if (result.isRanged()) {
                        tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "min_output", result.min).m_130940_(ChatFormatting.GRAY));
                        tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "max_output", result.max).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "exact_output", result.min).m_130940_(ChatFormatting.GRAY));
                    }
                }

                public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
                    tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "output_chance", StringUtils.format(chance, "0.00")).m_130940_(ChatFormatting.GRAY));
                    if (result.isRanged()) {
                        tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "min_output", result.min).m_130940_(ChatFormatting.GRAY));
                        tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "max_output", result.max).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "exact_output", result.min).m_130940_(ChatFormatting.GRAY));
                    }
                }
            });
        });
    }

    public void draw(PiglinBarteringRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Piglin piglin = (Piglin)EntityType.f_20511_.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        piglin.m_34670_(true);
        piglin.m_8061_(EquipmentSlot.MAINHAND, Items.f_42430_.m_7968_());
        recipeSlotsView.findSlotByName("inputSlot").flatMap(slot -> slot.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK)).ifPresent(inputStack -> {
            piglin.m_8061_(EquipmentSlot.OFFHAND, inputStack);
            piglin.m_6274_().m_21879_(MemoryModuleType.f_26336_, (Object)true);
        });
        boolean emptyInOffhand = piglin.m_21206_().m_41619_();
        if (emptyInOffhand) {
            double yaw = 30.0 - mouseX;
            double pitch = 45.0 - mouseY;
            piglin.f_20883_ = (float)Math.atan(yaw / 40.0) * 20.0f;
            piglin.m_146922_((float)Math.atan(yaw / 40.0) * 40.0f);
            piglin.m_146926_((float)Math.atan(pitch / 40.0) * -20.0f);
            piglin.f_20885_ = piglin.m_146908_();
            piglin.f_20886_ = piglin.m_146908_();
        }
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        stack.m_85837_(emptyInOffhand ? 25.0 : 33.0, 103.0, 50.0);
        stack.m_85841_(-32.0f, 32.0f, 32.0f);
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (!emptyInOffhand) {
            stack.m_252781_(Axis.f_252392_.m_252977_(45.0f));
        }
        EntityRenderDispatcher entityRendererDispatcher = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRendererDispatcher.m_114468_(false);
        entityRendererDispatcher.m_114384_((Entity)piglin, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)multiBufferSource, 0xF000F0);
        entityRendererDispatcher.m_114468_(true);
        multiBufferSource.m_109911_();
        stack.m_85849_();
    }
}

