/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.integration.jei.ModIntegrationJei;
import com.sihenzhang.crockpot.util.I18nUtils;
import java.util.Set;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class FoodValuesCategory
implements IRecipeCategory<FoodCategoryMatchedItems> {
    public static final RecipeType<FoodCategoryMatchedItems> RECIPE_TYPE = RecipeType.create((String)"crockpot", (String)"food_values", FoodCategoryMatchedItems.class);
    private final int WIDTH = 178;
    private final int HEIGHT = 110;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic slotDrawable;
    private final IScrollGridWidgetFactory<?> scrollGridFactory;

    public FoodValuesCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(178, 110);
        this.icon = guiHelper.createDrawable(ModIntegrationJei.ICONS, 16, 0, 16, 16);
        this.slotDrawable = guiHelper.getSlotDrawable();
        IScrollGridWidgetFactory scrollGridFactory = guiHelper.createScrollGridFactory(9, 5);
        scrollGridFactory.setPosition((178 - scrollGridFactory.getArea().f_263770_()) / 2, 20);
        this.scrollGridFactory = scrollGridFactory;
    }

    public RecipeType<FoodCategoryMatchedItems> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return I18nUtils.createIntegrationComponent("jei", "food_values");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FoodCategoryMatchedItems recipe, IFocusGroup focuses) {
        recipe.items().forEach(stack -> builder.addSlotToWidget(RecipeIngredientRole.INPUT, this.scrollGridFactory).addItemStack(stack));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (178 - this.slotDrawable.getWidth()) / 2 + 1, 1).addItemStack(FoodCategory.getItemStack(recipe.category()))).setBackground((IDrawable)this.slotDrawable, -1, -1);
    }

    public record FoodCategoryMatchedItems(FoodCategory category, Set<ItemStack> items) {
    }
}

