/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.event;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.block.food.PowCakeBlock;
import com.sihenzhang.crockpot.item.CrockPotItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crockpot")
public class AnimalsFollowPowcakeEvent {
    @SubscribeEvent
    public static void onAnimalAppear(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof Animal) {
            Animal animal = (Animal)entity;
            boolean hasTemptGoal = false;
            boolean hasEatGoal = false;
            for (WrappedGoal wrappedGoal : animal.f_21345_.m_148105_()) {
                if (wrappedGoal == null) continue;
                Goal goal = wrappedGoal.m_26015_();
                hasTemptGoal = hasTemptGoal || AnimalsFollowPowcakeEvent.isTemptGoal(goal);
                hasEatGoal = hasEatGoal || AnimalsFollowPowcakeEvent.isEatGoal(goal);
            }
            if (!hasTemptGoal) {
                try {
                    animal.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)animal, 0.8, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CrockPotItems.POW_CAKE.get()}), false));
                }
                catch (Exception ignored) {
                    CrockPot.LOGGER.error("Error when adding TemptGoal to {} {}", (Object)animal.getClass().getName(), (Object)animal);
                }
            }
            if (!hasEatGoal) {
                try {
                    animal.f_21345_.m_25352_(4, (Goal)new PowCakeBlock.AnimalEatPowCakeGoal((PathfinderMob)animal, 0.8, 3));
                }
                catch (Exception ignored) {
                    CrockPot.LOGGER.error("Error when adding AnimalEatPowCakeGoal to {} {}", (Object)animal.getClass().getName(), (Object)animal);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTemptGoal(Goal goal) {
        if (!(goal instanceof TemptGoal)) return false;
        TemptGoal temptGoal = (TemptGoal)goal;
        if (!temptGoal.f_25935_.test(((Item)CrockPotItems.POW_CAKE.get()).m_7968_())) return false;
        return true;
    }

    private static boolean isEatGoal(Goal goal) {
        return goal instanceof PowCakeBlock.AnimalEatPowCakeGoal;
    }
}

