/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.data.recipes.AbstractFinishedRecipe;
import com.sihenzhang.crockpot.data.recipes.AbstractRecipeBuilder;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ExplosionCraftingRecipeBuilder
extends AbstractRecipeBuilder {
    private final Item result;
    private final int resultCount;
    private final Ingredient ingredient;
    private float lossRate = 0.0f;
    private boolean onlyBlock = false;

    public ExplosionCraftingRecipeBuilder(ItemLike result, int resultCount, Ingredient ingredient) {
        this.result = result.m_5456_();
        this.resultCount = resultCount;
        this.ingredient = ingredient;
    }

    public static ExplosionCraftingRecipeBuilder explosionCrafting(ItemLike result, int resultCount, Ingredient ingredient) {
        return new ExplosionCraftingRecipeBuilder(result, resultCount, ingredient);
    }

    public static ExplosionCraftingRecipeBuilder explosionCrafting(ItemLike result, Ingredient ingredient) {
        return ExplosionCraftingRecipeBuilder.explosionCrafting(result, 1, ingredient);
    }

    public ExplosionCraftingRecipeBuilder lossRate(float lossRate) {
        this.lossRate = Mth.m_14036_((float)lossRate, (float)0.0f, (float)1.0f);
        return this;
    }

    public ExplosionCraftingRecipeBuilder onlyBlock() {
        this.onlyBlock = true;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.ingredient, this.result, this.resultCount, this.lossRate, this.onlyBlock));
    }

    public static class Result
    extends AbstractFinishedRecipe {
        private final Ingredient ingredient;
        private final Item result;
        private final int resultCount;
        private final float lossRate;
        private final boolean onlyBlock;

        public Result(ResourceLocation id, Ingredient ingredient, Item result, int resultCount, float lossRate, boolean onlyBlock) {
            super(id);
            this.ingredient = ingredient;
            this.result = result;
            this.resultCount = resultCount;
            this.lossRate = lossRate;
            this.onlyBlock = onlyBlock;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            String resultKey = ForgeRegistries.ITEMS.getKey((Object)this.result).toString();
            if (this.resultCount > 1) {
                JsonObject resultObject = new JsonObject();
                resultObject.addProperty("item", resultKey);
                resultObject.addProperty("count", (Number)this.resultCount);
                pJson.add("result", (JsonElement)resultObject);
            } else {
                pJson.addProperty("result", resultKey);
            }
            if (this.lossRate > 0.0f) {
                pJson.addProperty("lossrate", (Number)Float.valueOf(Math.min(this.lossRate, 1.0f)));
            }
            if (this.onlyBlock) {
                pJson.addProperty("onlyblock", Boolean.valueOf(true));
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_SERIALIZER.get();
        }
    }
}

