/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data;

import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.block.AbstractCrockPotDoubleCropBlock;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.block.food.AbstractStackableFoodBlock;
import com.sihenzhang.crockpot.entity.CrockPotEntities;
import com.sihenzhang.crockpot.item.CrockPotItems;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.data.loot.packs.VanillaEntityLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class CrockPotLootTableProvider
extends LootTableProvider {
    public CrockPotLootTableProvider(PackOutput output) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(CrockPotBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(CrockPotEntityLoot::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        map.forEach((name, table) -> table.m_79136_(validationTracker));
    }

    public static class CrockPotEntityLoot
    extends VanillaEntityLoot {
        public void m_246942_() {
            this.m_245309_((EntityType)CrockPotEntities.VOLT_GOAT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CrockPotItems.VOLT_GOAT_HORN.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-2.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_80806_(2)))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return Stream.of((EntityType)CrockPotEntities.VOLT_GOAT.get());
        }
    }

    public static class CrockPotBlockLoot
    extends VanillaBlockLoot {
        protected void m_245660_() {
            this.m_247577_((Block)CrockPotBlocks.CROCK_POT.get(), this.m_245142_((Block)CrockPotBlocks.CROCK_POT.get(), (ItemLike)Blocks.f_50069_, (NumberProvider)ConstantValue.m_165692_((float)6.0f)));
            this.m_245724_((Block)CrockPotBlocks.PORTABLE_CROCK_POT.get());
            this.m_247577_((Block)CrockPotBlocks.BIRDCAGE.get(), this.m_247398_((Block)CrockPotBlocks.BIRDCAGE.get()));
            this.m_245724_((Block)CrockPotBlocks.UNKNOWN_CROPS.get());
            this.m_247577_((Block)CrockPotBlocks.ASPARAGUS.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.ASPARAGUS.get(), (Item)CrockPotItems.ASPARAGUS.get(), (Item)CrockPotItems.ASPARAGUS_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.ASPARAGUS.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_247577_((Block)CrockPotBlocks.EGGPLANT.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.EGGPLANT.get(), (Item)CrockPotItems.EGGPLANT.get(), (Item)CrockPotItems.EGGPLANT_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.EGGPLANT.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_247577_((Block)CrockPotBlocks.GARLIC.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.GARLIC.get(), (Item)CrockPotItems.GARLIC.get(), (Item)CrockPotItems.GARLIC_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.GARLIC.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_247577_((Block)CrockPotBlocks.ONION.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.ONION.get(), (Item)CrockPotItems.ONION.get(), (Item)CrockPotItems.ONION_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.ONION.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_247577_((Block)CrockPotBlocks.PEPPER.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.PEPPER.get(), (Item)CrockPotItems.PEPPER.get(), (Item)CrockPotItems.PEPPER_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.PEPPER.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_247577_((Block)CrockPotBlocks.TOMATO.get(), this.createCropDropsWithSeed((Block)CrockPotBlocks.TOMATO.get(), (Item)CrockPotItems.TOMATO.get(), (Item)CrockPotItems.TOMATO_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.TOMATO.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            CrockPotBlocks.FOODS.get().forEach(this::dropFood);
        }

        protected LootTable.Builder createCropDropsWithSeed(Block pCropBlock, Item pGrownCropItem, Item pSeedsItem, LootItemCondition.Builder pDropGrownCropCondition) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pSeedsItem))).m_79161_(LootPool.m_79043_().m_79080_(pDropGrownCropCondition).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)pGrownCropItem, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)pGrownCropItem).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))));
        }

        protected static LootItemCondition.Builder blockStatePropertyCondition(Block pBlock, Property<Integer> pProperty, int pValue) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_(pProperty, pValue));
        }

        protected void dropFood(Block block) {
            if (block instanceof AbstractStackableFoodBlock) {
                AbstractStackableFoodBlock stackableFoodBlock = (AbstractStackableFoodBlock)block;
                LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)stackableFoodBlock, LootItem.m_79579_((ItemLike)stackableFoodBlock).m_230984_(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)), p_249985_ -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)p_249985_.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)stackableFoodBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)stackableFoodBlock.getStacksProperty(), p_249985_.intValue())))))));
                this.m_247577_(block, lootTable);
            } else {
                this.m_245724_(block);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return CrockPotBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> !(block instanceof AbstractCrockPotDoubleCropBlock)).toList();
        }
    }
}

