/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.CrockPotConfigs;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.util.I18nUtils;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class FoodValuesTooltip {
    private static final MutableComponent DELIMITER = Component.m_237113_((String)", ").m_130940_(ChatFormatting.WHITE);

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        FoodValues foodValues;
        if (!((Boolean)CrockPotConfigs.SHOW_FOOD_VALUES_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player != null && player.m_9236_() != null && !(foodValues = FoodValuesDefinition.getFoodValues(event.getItemStack(), player.m_9236_())).isEmpty()) {
            MutableComponent tooltip = foodValues.entrySet().stream().map(entry -> I18nUtils.createTooltipComponent("food_values", Component.m_237115_((String)("item.crockpot.food_category_" + ((FoodCategory)((Object)((Object)entry.getKey()))).name().toLowerCase(Locale.ROOT))), entry.getValue()).m_130948_(Style.f_131099_.m_131148_(((FoodCategory)((Object)((Object)entry.getKey()))).color)).m_130948_(Style.f_131099_.m_131148_(((FoodCategory)((Object)((Object)entry.getKey()))).color))).reduce(null, (acc, foodValuesText) -> acc == null ? foodValuesText : acc.m_7220_((Component)DELIMITER).m_7220_((Component)foodValuesText));
            event.getToolTip().add(tooltip);
        }
    }
}

