/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block.entity;

import com.google.common.base.Preconditions;
import com.sihenzhang.crockpot.CrockPotConfigs;
import com.sihenzhang.crockpot.base.CrockPotSoundEvents;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntities;
import com.sihenzhang.crockpot.inventory.CrockPotMenu;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.util.I18nUtils;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CrockPotBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot < 4) {
                return CrockPotBlockEntity.this.isValidIngredient(stack);
            }
            if (slot == 4) {
                return CrockPotBlockEntity.isFuel(stack);
            }
            return super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CrockPotBlockEntity.this.markUpdated();
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 4);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 5);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 5, 6);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level pLevel, BlockPos pPos, BlockState pState) {
            CrockPotBlockEntity.this.playSound(pState, (SoundEvent)CrockPotSoundEvents.CROCK_POT_OPEN.get());
            CrockPotBlockEntity.this.updateBlockState(pState, true);
        }

        protected void m_142289_(Level pLevel, BlockPos pPos, BlockState pState) {
            CrockPotBlockEntity.this.playSound(pState, (SoundEvent)CrockPotSoundEvents.CROCK_POT_CLOSE.get());
            CrockPotBlockEntity.this.updateBlockState(pState, false);
        }

        protected void m_142148_(Level pLevel, BlockPos pPos, BlockState pState, int pCount, int pOpenCount) {
        }

        protected boolean m_142718_(Player pPlayer) {
            AbstractContainerMenu abstractContainerMenu = pPlayer.f_36096_;
            if (abstractContainerMenu instanceof CrockPotMenu) {
                CrockPotMenu crockPotMenu = (CrockPotMenu)abstractContainerMenu;
                return crockPotMenu.getBlockEntity() == CrockPotBlockEntity.this;
            }
            return false;
        }
    };
    private final int potLevel;
    private int burningTime;
    private int burningTotalTime;
    private int cookingTime;
    private int cookingTotalTime;
    private ItemStack result = ItemStack.f_41583_;
    private int cookingSoundPlayingTime;
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerInputCap = LazyOptional.of(() -> this.itemHandlerInput);
    private final LazyOptional<IItemHandler> itemHandlerFuelCap = LazyOptional.of(() -> this.itemHandlerFuel);
    private final LazyOptional<IItemHandler> itemHandlerOutputCap = LazyOptional.of(() -> this.itemHandlerOutput);

    public CrockPotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CrockPotBlockEntities.CROCK_POT_BLOCK_ENTITY.get(), pPos, pBlockState);
        Preconditions.checkArgument((boolean)(pBlockState.m_60734_() instanceof CrockPotBlock), (Object)"Block of the `CrockPotEntity` must be an instance of `CrockPotBlock`.");
        this.potLevel = ((CrockPotBlock)pBlockState.m_60734_()).getPotLevel();
    }

    public Component m_5446_() {
        return I18nUtils.createComponent("container", "crock_pot");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CrockPotMenu(pContainerId, pPlayerInventory, this);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, CrockPotBlockEntity pBlockEntity) {
        boolean hasChanged = false;
        boolean isBurning = pBlockEntity.isBurning();
        if (pBlockEntity.isBurning()) {
            --pBlockEntity.burningTime;
            hasChanged = true;
        }
        ItemStack fuelStack = pBlockEntity.itemHandlerFuel.getStackInSlot(0);
        if (pBlockEntity.isBurning() || CrockPotBlockEntity.isFuel(fuelStack)) {
            Optional<CrockPotCookingRecipe> optionalRecipe;
            CrockPotCookingRecipe.Wrapper recipeWrapper;
            if (!pBlockEntity.isCooking() && pBlockEntity.itemHandlerOutput.getStackInSlot(0).m_41619_() && (recipeWrapper = pBlockEntity.getRecipeWrapper()) != null && (optionalRecipe = CrockPotCookingRecipe.getRecipeFor(recipeWrapper, pLevel)).isPresent()) {
                CrockPotCookingRecipe recipe = optionalRecipe.get();
                pBlockEntity.cookingTotalTime = pBlockEntity.getActualCookingTotalTime(recipe);
                pBlockEntity.result = recipe.assemble(recipeWrapper, pLevel.m_9598_());
                pBlockEntity.shrinkInputs();
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, (NonNullList)recipe.m_7457_((Container)recipeWrapper));
                hasChanged = true;
            }
            if (pBlockEntity.isCooking()) {
                if (!pBlockEntity.isBurning() && CrockPotBlockEntity.isFuel(fuelStack)) {
                    pBlockEntity.burningTime = pBlockEntity.burningTotalTime = ForgeHooks.getBurnTime((ItemStack)fuelStack, null);
                    ItemStack remainingItem = fuelStack.getCraftingRemainingItem();
                    fuelStack.m_41774_(1);
                    if (fuelStack.m_41619_()) {
                        pBlockEntity.itemHandlerFuel.setStackInSlot(0, remainingItem);
                    }
                    hasChanged = true;
                }
                if (pBlockEntity.isBurning() && pBlockEntity.itemHandlerOutput.getStackInSlot(0).m_41619_()) {
                    ++pBlockEntity.cookingTime;
                    if (pBlockEntity.cookingSoundPlayingTime % 5 == 0) {
                        pBlockEntity.playSound(pState, (SoundEvent)CrockPotSoundEvents.CROCK_POT_RATTLE.get());
                        pBlockEntity.cookingSoundPlayingTime = 0;
                    }
                    ++pBlockEntity.cookingSoundPlayingTime;
                    if (pBlockEntity.cookingTime >= pBlockEntity.cookingTotalTime) {
                        pBlockEntity.cookingTime = 0;
                        pBlockEntity.itemHandlerOutput.setStackInSlot(0, pBlockEntity.result);
                        pBlockEntity.result = ItemStack.f_41583_;
                    }
                    hasChanged = true;
                }
            }
        }
        if (!pBlockEntity.isBurning()) {
            pBlockEntity.cookingSoundPlayingTime = 0;
        }
        if (isBurning != pBlockEntity.isBurning()) {
            pState = (BlockState)pState.m_61124_((Property)CrockPotBlock.LIT, (Comparable)Boolean.valueOf(pBlockEntity.isBurning()));
            pLevel.m_7731_(pPos, pState, 3);
            hasChanged = true;
        }
        if (hasChanged) {
            pBlockEntity.markUpdated();
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    @Nullable
    public CrockPotCookingRecipe.Wrapper getRecipeWrapper() {
        int size = this.itemHandlerInput.getSlots();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stackInSlot = this.itemHandlerInput.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                return null;
            }
            stacks.add(stackInSlot.m_255036_(1));
        }
        FoodValues mergedFoodValues = FoodValues.merge(stacks.stream().map(stack -> FoodValuesDefinition.getFoodValues(stack, this.f_58857_)).toList());
        return new CrockPotCookingRecipe.Wrapper(stacks, mergedFoodValues, this.getPotLevel());
    }

    public boolean isValidIngredient(ItemStack stack) {
        return !FoodValuesDefinition.getFoodValues(stack, this.f_58857_).isEmpty();
    }

    public static boolean isFuel(ItemStack pStack) {
        return ForgeHooks.getBurnTime((ItemStack)pStack, null) > 0;
    }

    public boolean isBurning() {
        return this.burningTime > 0;
    }

    public float getBurningProgress() {
        return this.burningTotalTime != 0 ? (float)this.burningTime / (float)this.burningTotalTime : 0.0f;
    }

    public boolean isCooking() {
        return this.result != null && !this.result.m_41619_();
    }

    public float getCookingProgress() {
        return this.cookingTotalTime != 0 ? (float)this.cookingTime / (float)this.cookingTotalTime : 0.0f;
    }

    public ItemStack getResult() {
        return this.result;
    }

    private void shrinkInputs() {
        for (int i = 0; i < this.itemHandlerInput.getSlots(); ++i) {
            this.itemHandlerInput.getStackInSlot(i).m_41774_(1);
        }
    }

    private int getActualCookingTotalTime(CrockPotCookingRecipe recipe) {
        return Math.max((int)((double)recipe.getCookingTime() * (1.0 - (Double)CrockPotConfigs.CROCK_POT_SPEED_MODIFIER.get() * (double)this.getPotLevel())), 1);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("ItemHandler"));
        this.burningTime = pTag.m_128451_("BurningTime");
        this.burningTotalTime = pTag.m_128451_("BurningTotalTime");
        this.cookingTime = pTag.m_128451_("CookingTime");
        this.cookingTotalTime = pTag.m_128451_("CookingTotalTime");
        if (pTag.m_128425_("Result", 10)) {
            this.result.deserializeNBT(pTag.m_128469_("Result"));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("ItemHandler", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("BurningTime", this.burningTime);
        pTag.m_128405_("BurningTotalTime", this.burningTotalTime);
        pTag.m_128405_("CookingTime", this.cookingTime);
        pTag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        pTag.m_128365_("Result", (Tag)this.result.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("ItemHandler", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("BurningTime", this.burningTime);
        tag.m_128405_("BurningTotalTime", this.burningTotalTime);
        tag.m_128405_("CookingTime", this.cookingTime);
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void markUpdated() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void startOpen(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState pState, boolean pOpen) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)CrockPotBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)CrockPotBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.itemHandlerCap.cast();
            }
            return switch (side) {
                case Direction.UP -> this.itemHandlerInputCap.cast();
                case Direction.DOWN -> this.itemHandlerOutputCap.cast();
                default -> this.itemHandlerFuelCap.cast();
            };
        }
        return super.getCapability(cap, side);
    }
}

