/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public abstract class AbstractCrockPotDoubleCropBlock
extends AbstractCrockPotCropBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Shapes.m_83144_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Shapes.m_83144_()};

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public boolean isUpperBlock(BlockState state) {
        return this.m_52305_(state) > this.m_7419_() / 2;
    }

    public int getMaxGrowthAge(BlockState state) {
        return this.isUpperBlock(state) ? this.m_7419_() : this.m_7419_() / 2;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (!level.f_46443_ && this.isUpperBlock(state) && (lowerState = level.m_8055_(lowerPos = pos.m_7495_())).m_60713_((Block)this)) {
            level.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        float growthChance;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && (age = this.m_52305_(state)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (growthChance = AbstractCrockPotDoubleCropBlock.getGrowthChance(this, (BlockGetter)level, blockPos = this.isUpperBlock(state) && level.m_8055_(pos.m_7495_()).m_60734_() == this ? pos.m_7495_() : pos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (age != this.getMaxGrowthAge(state)) {
                level.m_7731_(pos, this.m_52289_(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            } else if (level.m_46859_(pos.m_7494_())) {
                level.m_7731_(pos.m_7494_(), this.m_52289_(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        int maxAge;
        int age = this.m_52305_(state);
        if (age < (maxAge = this.m_7419_())) {
            int maxGrowthAge = this.getMaxGrowthAge(state);
            if (age != maxGrowthAge) {
                int expectedAge = age + this.m_7125_(level);
                if (expectedAge > maxAge) {
                    expectedAge = maxAge;
                }
                if (expectedAge > maxGrowthAge) {
                    level.m_7731_(pos, this.m_52289_(maxGrowthAge), 2);
                    if (level.m_46859_(pos.m_7494_())) {
                        level.m_7731_(pos.m_7494_(), this.m_52289_(expectedAge), 2);
                    }
                } else {
                    level.m_7731_(pos, this.m_52289_(expectedAge), 2);
                }
            } else {
                BlockState stateUp = level.m_8055_(pos.m_7494_());
                if (stateUp.m_60734_() == this && this.m_52305_(stateUp) != this.getMaxGrowthAge(stateUp)) {
                    int expectedAge = this.m_52305_(stateUp) + this.m_7125_(level);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    level.m_7731_(pos.m_7494_(), this.m_52289_(expectedAge), 2);
                } else if (level.m_46859_(pos.m_7494_())) {
                    int expectedAge = age + this.m_7125_(level);
                    if (expectedAge > maxAge) {
                        expectedAge = maxAge;
                    }
                    level.m_7731_(pos.m_7494_(), this.m_52289_(expectedAge), 2);
                }
            }
        }
    }

    protected static float getGrowthChance(AbstractCrockPotDoubleCropBlock block, BlockGetter level, BlockPos pos) {
        if (block.isUpperBlock(level.m_8055_(pos))) {
            return CropBlock.m_52272_((Block)block, (BlockGetter)level, (BlockPos)pos.m_7495_());
        }
        return CropBlock.m_52272_((Block)block, (BlockGetter)level, (BlockPos)pos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isUpperBlock(state)) {
            BlockState stateDown = level.m_8055_(pos.m_7495_());
            return (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) && stateDown.m_60734_() == this && this.m_52305_(stateDown) == this.getMaxGrowthAge(stateDown);
        }
        return super.m_7898_(state, level, pos);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        if (this.m_52305_(state) < this.m_7419_()) {
            if (this.m_52305_(state) != this.getMaxGrowthAge(state)) {
                return true;
            }
            BlockState stateUp = level.m_8055_(pos.m_7494_());
            return stateUp.m_60734_() == this && this.m_52305_(stateUp) != this.getMaxGrowthAge(stateUp) || stateUp.m_60795_();
        }
        return false;
    }
}

