/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record PlayerJumpPacketC2S(boolean jumpBySelf, boolean resetFallDistance, float motionY) {
    public static void encode(PlayerJumpPacketC2S packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(packet.jumpBySelf);
        friendlyByteBuf.writeBoolean(packet.resetFallDistance);
        friendlyByteBuf.writeFloat(packet.motionY);
    }

    public static PlayerJumpPacketC2S decode(FriendlyByteBuf friendlyByteBuf) {
        return new PlayerJumpPacketC2S(friendlyByteBuf.readBoolean(), friendlyByteBuf.readBoolean(), friendlyByteBuf.readFloat());
    }

    public static void handle(PlayerJumpPacketC2S packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            serverPlayer.f_19812_ = true;
            if (packet.jumpBySelf) {
                serverPlayer.m_36220_(Stats.f_12926_);
                serverPlayer.m_36399_(serverPlayer.m_20142_() ? 0.2f : 0.05f);
            }
            if (packet.resetFallDistance) {
                serverPlayer.m_183634_();
            }
            Vec3 motion = serverPlayer.m_20184_();
            serverPlayer.m_20334_(motion.f_82479_, (double)packet.motionY, motion.f_82481_);
        });
        context.setPacketHandled(true);
    }
}

