/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.combat;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.effect.ModEffects;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.misc.ModAttributes;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.misc.ModRarity;
import top.theillusivec4.curios.api.SlotContext;

public class MoonStone
extends BaseCurioItem {
    public static final UUID ATTACK_SPEED_UUID = UUID.fromString("E11BBE53-8620-4795-296E-B1E512E04EFF");
    public static final UUID DAMAGE_UUID = UUID.fromString("51D0544E-0AA8-CB0C-5FBC-1A4C6B5C99B7");
    public static final UUID ARMOR_UUID = UUID.fromString("35D05688-D0BE-3387-DAD8-82C79B46AB46");
    public static final UUID CRIT_UUID = UUID.fromString("3CCCFFBE-2975-FFF3-FF4C-2AF08AA74CC4");
    public static final UUID MINING_UUID = UUID.fromString("BD0CC75B-8DE2-CDAC-35C7-B8947CB285F2");
    public static final UUID RANGED_UUID = UUID.fromString("6E8B22E4-8888-8C96-12B0-4B4C5CE84593");
    public static final UUID MAGIC_UUID = UUID.fromString("303F8134-E854-5D38-5722-1457C99605E2");
    private static ImmutableMultimap<Attribute, AttributeModifier> ATTRIBUTES;

    public MoonStone() {
        super(ModRarity.PINK);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity living;
        if (ATTRIBUTES == null) {
            ATTRIBUTES = ImmutableMultimap.builder().put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ATTACK_SPEED_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_SPEED.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DAMAGE_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_DAMAGE.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Moon Stone", (double)((Integer)ModConfigs.MOON_STONE_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION)).put((Object)ModAttributes.getCriticalChance(), (Object)new AttributeModifier(CRIT_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_CRITICAL_CHANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION)).put((Object)ModAttributes.getMiningSpeed(), (Object)new AttributeModifier(MINING_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_MINING.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)ModAttributes.getRangedDamage(), (Object)new AttributeModifier(RANGED_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_RANGED.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)ModAttributes.getMagicDamage(), (Object)new AttributeModifier(MAGIC_UUID, "Moon Stone", ((Double)ModConfigs.MOON_STONE_MAGIC.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).build();
        }
        if ((living = slotContext.entity()) == null) {
            return EMPTY_ATTRIBUTE;
        }
        return living.m_9236_().m_46468_() % 24000L > 12000L ? ATTRIBUTES : EMPTY_ATTRIBUTE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        if (living.m_9236_().m_46468_() % 24000L < 12000L) {
            return;
        }
        ModEffects.healPerSecond(living, 2.0f);
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.confluence.moon_stone.info")};
    }
}

