/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.block.ModBlocks;
import org.confluence.mod.integration.jei.JeiBackGround;
import org.confluence.mod.integration.jei.WorkshopCategory;
import org.confluence.mod.item.ModItems;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.recipe.AmountIngredient;
import org.confluence.mod.recipe.ModRecipes;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ModJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("confluence", "jei_plugin");
    public static final ResourceLocation ARROW_RIGHT = new ResourceLocation("confluence", "textures/gui/arrow_right.png");
    public static final JeiBackGround HALF_BACKGROUND = new JeiBackGround(128, 64);

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkshopCategory(jeiHelpers)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addItemStackInfo(new ItemStack((ItemLike)ModItems.DEMON_HEART.get()), new Component[]{Component.m_237115_((String)"item.confluence.demon_heart.info")});
        for (CurioItems curio : CurioItems.values()) {
            BaseCurioItem item = (BaseCurioItem)((Object)curio.get());
            Component[] information = item.getInformation();
            if (information.length == 0) continue;
            registration.addItemStackInfo(new ItemStack((ItemLike)item), information);
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.m_7465_();
        registration.addRecipes(WorkshopCategory.TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.WORKSHOP_TYPE.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WORKSHOP.get()), new RecipeType[]{WorkshopCategory.TYPE});
    }

    public static void drawArrowRight(GuiGraphics guiGraphics, int x, int y, boolean usable) {
        guiGraphics.m_280163_(ARROW_RIGHT, x, y, 0.0f, usable ? 0.0f : 21.0f, 28, 21, 42, 42);
    }

    public static void addInput(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        if (!ingredient.m_43947_() && ingredient instanceof AmountIngredient) {
            AmountIngredient amountIngredient = (AmountIngredient)ingredient;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStack(amountIngredient.getItemStack());
        }
    }
}

