/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.confluence.mod.Confluence;
import org.confluence.mod.datagen.limit.CustomModel;
import org.confluence.mod.item.ModItems;
import org.confluence.mod.item.common.IconItem;
import org.confluence.mod.item.curio.BaseCurioItem;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "confluence", existingFileHelper);
    }

    protected void registerModels() {
        for (IconItem.Icons icons : IconItem.Icons.values()) {
            String path = icons.name().toLowerCase();
            ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation("confluence", "item/" + path));
        }
        ModItems.ITEMS.getEntries().forEach(item -> {
            try {
                BlockItem blockItem;
                Item value = (Item)item.get();
                if (value instanceof CustomModel || value instanceof BlockItem && (blockItem = (BlockItem)value).m_40614_() instanceof CustomModel) {
                    return;
                }
                String path = item.getId().m_135815_().toLowerCase();
                if (value instanceof BaseCurioItem) {
                    ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation("confluence", "item/curio/" + path));
                } else {
                    ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation("confluence", "item/" + path));
                }
            }
            catch (Exception e) {
                Confluence.LOGGER.error(e.getMessage());
            }
        });
    }
}

