/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.mod.client.handler.StepStoolHandler;
import org.confluence.mod.integration.airhop.AirHopHelper;
import org.confluence.mod.misc.ModSoundEvents;
import org.confluence.mod.mixin.LivingEntityAccessor;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.c2s.PlayerJumpPacketC2S;
import org.confluence.mod.network.s2c.PlayerFlyPacketS2C;
import org.confluence.mod.network.s2c.PlayerJumpPacketS2C;

@OnlyIn(value=Dist.CLIENT)
public final class PlayerJumpHandler {
    private static boolean jumpKeyDown = true;
    private static double fartSpeed = 0.0;
    private static boolean fartFinished = false;
    private static double sandstormSpeed = 0.0;
    private static int maxSandstormTicks = 0;
    private static int remainSandstormTicks = 0;
    private static boolean sandstormFinished = false;
    private static double blizzardSpeed = 0.0;
    private static int maxBlizzardTicks = 0;
    private static int remainBlizzardTicks = 0;
    private static boolean blizzardFinished = false;
    private static double tsunamiSpeed = 0.0;
    private static boolean tsunamiFinished = false;
    private static double cloudSpeed = 0.0;
    private static boolean cloudFinished = false;
    private static double flySpeed = 0.0;
    private static int maxFlyTicks = 0;
    private static int remainFlyTicks = 0;
    public static boolean onFly = false;

    public static void handle(LocalPlayer localPlayer, boolean jumping) {
        if (StepStoolHandler.onStool()) {
            return;
        }
        if (localPlayer.m_20096_()) {
            PlayerJumpHandler.flushState(true);
        } else if (jumping) {
            if (AirHopHelper.isLoaded() && AirHopHelper.notFinishJump((Player)localPlayer)) {
                jumpKeyDown = true;
                return;
            }
            if (jumpKeyDown) {
                return;
            }
            if (!fartFinished && fartSpeed > 0.0) {
                fartFinished = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, fartSpeed);
                localPlayer.m_216990_((SoundEvent)ModSoundEvents.FART_SOUND.get());
            } else if (!sandstormFinished && sandstormSpeed > 0.0) {
                if (remainSandstormTicks-- > 0) {
                    PlayerJumpHandler.oneTimeJump(localPlayer, sandstormSpeed);
                } else {
                    jumpKeyDown = true;
                }
            } else if (!blizzardFinished && blizzardSpeed > 0.0) {
                if (remainBlizzardTicks-- > 0) {
                    PlayerJumpHandler.oneTimeJump(localPlayer, blizzardSpeed);
                } else {
                    jumpKeyDown = true;
                }
            } else if (!tsunamiFinished && tsunamiSpeed > 0.0) {
                tsunamiFinished = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, tsunamiSpeed);
                localPlayer.m_216990_((SoundEvent)ModSoundEvents.DOUBLE_JUMP.get());
            } else if (!cloudFinished && cloudSpeed > 0.0) {
                cloudFinished = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, cloudSpeed);
                localPlayer.m_216990_((SoundEvent)ModSoundEvents.DOUBLE_JUMP.get());
            } else if (remainFlyTicks-- > 0) {
                PlayerJumpHandler.fly(localPlayer, flySpeed);
            } else {
                jumpKeyDown = true;
            }
        } else {
            jumpKeyDown = false;
            sandstormFinished = remainSandstormTicks < maxSandstormTicks;
            blizzardFinished = remainBlizzardTicks < maxBlizzardTicks;
            onFly = false;
        }
    }

    public static void flushState(boolean jumpKey) {
        jumpKeyDown = jumpKey;
        fartFinished = false;
        remainSandstormTicks = maxSandstormTicks;
        sandstormFinished = false;
        remainBlizzardTicks = maxBlizzardTicks;
        blizzardFinished = false;
        tsunamiFinished = false;
        cloudFinished = false;
        remainFlyTicks = maxFlyTicks;
    }

    private static void multiJump(LocalPlayer localPlayer, double speed) {
        Vec3 vec3 = localPlayer.m_20184_();
        double motionY = (double)((LivingEntityAccessor)localPlayer).callGetJumpPower() * speed;
        localPlayer.m_20334_(vec3.f_82479_, motionY, vec3.f_82481_);
        if (localPlayer.m_20142_()) {
            float f = localPlayer.m_146908_() * ((float)Math.PI / 180);
            localPlayer.m_20256_(localPlayer.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
        }
        localPlayer.f_19812_ = true;
        localPlayer.m_183634_();
        NetworkHandler.CHANNEL.sendToServer((Object)new PlayerJumpPacketC2S(true, true, (float)speed));
    }

    private static void oneTimeJump(LocalPlayer localPlayer, double speed) {
        Vec3 vec3 = localPlayer.m_20184_();
        double y = vec3.f_82480_;
        y = y < speed ? (y += speed / 3.5) : speed;
        localPlayer.m_20334_(vec3.f_82479_, y, vec3.f_82481_);
        localPlayer.f_19812_ = true;
        localPlayer.m_183634_();
        NetworkHandler.CHANNEL.sendToServer((Object)new PlayerJumpPacketC2S(false, true, (float)y));
    }

    private static void fly(LocalPlayer localPlayer, double speed) {
        Vec3 vec3 = localPlayer.m_20184_();
        double y = vec3.f_82480_;
        y = y < speed ? (y += speed / 2.5) : speed;
        localPlayer.m_20334_(vec3.f_82479_, y, vec3.f_82481_);
        localPlayer.f_19812_ = true;
        localPlayer.m_183634_();
        NetworkHandler.CHANNEL.sendToServer((Object)new PlayerJumpPacketC2S(false, true, (float)y));
    }

    public static void handleJumpPacket(PlayerJumpPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (packet.fartSpeed() > -1.5) {
                fartSpeed = packet.fartSpeed();
            }
            sandstormSpeed = packet.sandstormSpeed();
            maxSandstormTicks = packet.sandstormTicks();
            blizzardSpeed = packet.blizzardSpeed();
            maxBlizzardTicks = packet.blizzardTicks();
            if (packet.tsunamiSpeed() > -1.5) {
                tsunamiSpeed = packet.tsunamiSpeed();
            }
            cloudSpeed = packet.cloudSpeed();
        });
        context.setPacketHandled(true);
    }

    public static void handleFlyPacket(PlayerFlyPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            maxFlyTicks = packet.maxFlyTicks();
            flySpeed = packet.flySpeed();
        });
        context.setPacketHandled(true);
    }
}

