/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.CuriosClient;
import org.confluence.mod.client.model.entity.BeeProjectileModel;
import org.confluence.mod.client.model.entity.StepStoolModel;
import org.confluence.mod.client.particle.CurrentColorDustParticle;
import org.confluence.mod.client.particle.ModParticles;
import org.confluence.mod.client.renderer.AchievementToast;
import org.confluence.mod.client.renderer.entity.BeeProjectileRenderer;
import org.confluence.mod.client.renderer.entity.StarCloakEntityRenderer;
import org.confluence.mod.client.renderer.entity.StepStoolRenderer;
import org.confluence.mod.client.renderer.gui.InfoHudOverlay;
import org.confluence.mod.client.renderer.gui.WorkshopScreen;
import org.confluence.mod.entity.ModEntities;
import org.confluence.mod.menu.ModMenus;

@Mod.EventBusSubscriber(modid="confluence", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ModClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CuriosClient.registerRenderers();
            ClientConfigs.onLoad();
            AchievementToast.registerToast("boots_of_the_hero");
            AchievementToast.registerToast("black_mirror");
            AchievementToast.registerToast("ankhumulation_complete");
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WORKSHOP.get()), WorkshopScreen::new);
        });
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("info_hud", (IGuiOverlay)new InfoHudOverlay());
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CuriosClient.registerLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        event.registerLayerDefinition(BeeProjectileModel.LAYER_LOCATION, BeeProjectileModel::createBodyLayer);
        event.registerLayerDefinition(StepStoolModel.LAYER_LOCATION, StepStoolModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.BEE_PROJECTILE.get(), BeeProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STAR_CLOAK.get(), StarCloakEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STEP_STOOL.get(), StepStoolRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.CURRENT_DUST.get(), CurrentColorDustParticle.Provider::new);
    }
}

