/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import java.util.Locale;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ForgeHooks;

public class PassableLeavesBlock
extends BaseLeavesBlock
implements BonemealableBlock {
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"type", State.class);

    public PassableLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected InteractionResult doClick(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(STATE) == State.FRUITS) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.dropFruit(state, sl, pos, level.m_213780_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    protected void doDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        PassableLeavesBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
    }

    protected void dropFruit(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doDropFruit(state, level, pos);
        level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.LEAVES)));
    }

    public boolean m_6724_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            return false;
        }
        if (state.m_61143_(STATE) != State.LEAVES) {
            return true;
        }
        return super.m_6724_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue() && !this.m_221385_(state)) {
            State st = (State)((Object)state.m_61143_(STATE));
            if (st == State.FLOWERS) {
                boolean grow;
                boolean bl = grow = random.m_188500_() < (Double)FDModConfig.COMMON.fruitsGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.FRUITS)));
                    BlockPos next = this.findNextFlowerTarget((Level)level, pos, e -> (Boolean)e.m_61143_((Property)f_54419_) == false && e.m_61143_(STATE) == State.LEAVES);
                    if (next != null) {
                        BlockState ns = level.m_8055_(next);
                        level.m_46597_(next, (BlockState)ns.m_61124_(STATE, (Comparable)((Object)State.FLOWERS)));
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == State.FRUITS && random.m_188500_() < (Double)FDModConfig.COMMON.fruitsDropChance.get()) {
                this.dropFruit(state, level, pos, random);
                return;
            }
        }
        super.m_213898_(state, level, pos, random);
    }

    @Override
    public BlockState flowerState() {
        return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)State.FLOWERS));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean client) {
        return (Boolean)state.m_61143_((Property)f_54419_) != false || state.m_61143_(STATE) == State.FLOWERS;
    }

    public boolean m_214167_(Level level, RandomSource r, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource r, BlockPos pos, BlockState state) {
        level.m_46597_(pos, (BlockState)state.m_61122_(STATE));
    }

    protected ConfiguredModel[] buildModel(RegistrateBlockstateProvider pvd, String treeName, BlockState state) {
        String name = treeName + "_" + ((State)((Object)state.m_61143_(STATE))).m_7912_();
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().withExistingParent(name, "block/leaves")).texture("all", "block/" + name)).build();
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(state -> this.buildModel(pvd, name, (BlockState)state), new Property[]{LeavesBlock.f_54418_, LeavesBlock.f_54419_, LeavesBlock.f_221367_});
    }

    @Override
    public void buildLoot(RegistrateBlockLootTables pvd, Block block, Block sapling, Item fruit) {
        LootPoolSingletonContainer.Builder leaves = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))));
        LootPoolSingletonContainer.Builder fruits = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)fruit).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(STATE, (Comparable)((Object)State.FRUITS))))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1));
        LootPoolSingletonContainer.Builder saplings = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)sapling).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}));
        AlternativesEntry.Builder drops = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{leaves, fruits, saplings});
        pvd.m_247577_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)drops).m_79080_(ExplosionCondition.m_81661_())));
    }

    public static enum State implements StringRepresentable
    {
        LEAVES,
        FLOWERS,
        FRUITS;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

