/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    public static void spawnThunder(Entity target) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(target.m_9236_());
        if (lightningBolt != null) {
            lightningBolt.m_20219_(target.m_20097_().m_252807_());
            target.m_9236_().m_7967_((Entity)lightningBolt);
        }
    }

    public static AABB getAABB(LivingEntity center, float radius, float height) {
        return center.m_20191_().m_82377_((double)radius, (double)height, (double)radius);
    }

    public static List<LivingEntity> getExceptForCentralEntity(LivingEntity center, float radius, float height, Predicate<LivingEntity> predicate) {
        List entities = center.m_9236_().m_6443_(LivingEntity.class, EntityUtils.getAABB(center, radius, height), predicate);
        entities.remove(center);
        return entities;
    }

    public static List<LivingEntity> getExceptForCentralEntity(LivingEntity center, float radius, float height) {
        List entities = center.m_9236_().m_45976_(LivingEntity.class, EntityUtils.getAABB(center, radius, height));
        entities.remove(center);
        return entities;
    }

    public static List<LivingEntity> getDelimitedMonster(LivingEntity center, int range) {
        return center.m_9236_().m_6443_(LivingEntity.class, center.m_20191_().m_82400_((double)range), entities -> entities instanceof Enemy);
    }

    public static boolean isLookingBehindTarget(LivingEntity target, @Nullable Vec3 attackerLocation) {
        if (attackerLocation != null) {
            Vec3 lookingVector = target.m_20252_(1.0f);
            Vec3 attackAngleVector = attackerLocation.m_82546_(target.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            return attackAngleVector.m_82526_(lookingVector) < -0.5;
        }
        return false;
    }

    public static void setPlayerXpLevel(Player player, int level) {
        player.f_36078_ = level;
    }

    public static boolean isEndEntity(LivingEntity entity) {
        return entity instanceof EnderMan || entity instanceof EnderDragon || entity instanceof Shulker || entity instanceof Endermite;
    }

    public static boolean hasArmor(LivingEntity le) {
        return !le.m_6844_(EquipmentSlot.HEAD).m_41619_() || !le.m_6844_(EquipmentSlot.CHEST).m_41619_() || !le.m_6844_(EquipmentSlot.LEGS).m_41619_() || !le.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    public static int getEffectCount(LivingEntity entity, MobEffectCategory category) {
        return (int)entity.m_21220_().stream().filter(e -> e.m_19544_().m_19483_() == category).count();
    }

    public static int getHarmfulEffect(LivingEntity entity) {
        return EntityUtils.getEffectCount(entity, MobEffectCategory.HARMFUL);
    }

    public static int getBeneficialEffect(LivingEntity entity) {
        return EntityUtils.getEffectCount(entity, MobEffectCategory.BENEFICIAL);
    }

    public static void addEct(LivingEntity entity, MobEffect effect, int time, int level) {
        entity.m_7292_(new MobEffectInstance(effect, time, level, false, false, true));
    }
}

