/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.register;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.xiaoyue.celestial_core.CelestialCore;
import com.xiaoyue.celestial_core.content.effects.ArrowDamage;
import com.xiaoyue.celestial_core.content.effects.BladeModifier;
import com.xiaoyue.celestial_core.content.effects.CritDamage;
import com.xiaoyue.celestial_core.content.effects.CritRate;
import com.xiaoyue.celestial_core.content.effects.Hidden;
import com.xiaoyue.celestial_core.content.effects.ReplyPower;
import com.xiaoyue.celestial_core.content.effects.RottenCurse;
import com.xiaoyue.celestial_core.content.effects.SoulShatter;
import com.xiaoyue.celestial_core.content.effects.Violent;
import com.xiaoyue.celestial_core.register.CCItems;
import dev.xkmc.l2library.base.L2Registrate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistries;

public class CCEffects {
    public static final List<RegistryEntry<? extends Potion>> POTION_LIST = new ArrayList<RegistryEntry<? extends Potion>>();
    private static final List<Runnable> TEMP = new ArrayList<Runnable>();
    public static final RegistryEntry<Violent> VIOLENT = CCEffects.genEffect("violent", Violent::new, "Melee damage bypass armor");
    public static final RegistryEntry<Hidden> HIDDEN = CCEffects.genEffect("hidden", Hidden::new, "Cannot be seen as enemy. Removed on attack");
    public static final RegistryEntry<RottenCurse> ROTTEN_CURSE = CCEffects.genEffect("rotten_curse", RottenCurse::new, "Inflict damage after being attacked, prevents teleport");
    public static final RegistryEntry<BladeModifier> BLADE_MODIFIER = CCEffects.genEffect("reinforced_blade", BladeModifier::new, "Increase attack damage and crit rate");
    public static final RegistryEntry<SoulShatter> SOUL_SHATTER = CCEffects.genEffect("soul_shatter", SoulShatter::new, "Reduce max health and movement speed");
    public static final RegistryEntry<CritRate> CRIT_RATE = CCEffects.genEffect("crit_rate", CritRate::new, "Increase crit rate");
    public static final RegistryEntry<CritDamage> CRIT_DAMAGE = CCEffects.genEffect("crit_damage", CritDamage::new, "Increase crit damage");
    public static final RegistryEntry<ReplyPower> REPLY_POWER = CCEffects.genEffect("regen_rate", ReplyPower::new, "Increase regeneration rate");
    public static final RegistryEntry<ArrowDamage> ARROW_DAMAGE = CCEffects.genEffect("arrow_damage", ArrowDamage::new, "Increase arrow damage");

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)CelestialCore.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    private static <T extends Potion> RegistryEntry<T> genPotion(String name, NonNullSupplier<T> sup) {
        L2Registrate reg = CelestialCore.REGISTRATE;
        RegistryEntry ans = ((NoConfigBuilder)reg.entry(name, cb -> new NoConfigBuilder((AbstractRegistrate)reg, (Object)reg, name, cb, ForgeRegistries.Keys.POTIONS, sup))).register();
        POTION_LIST.add((RegistryEntry<? extends Potion>)ans);
        return ans;
    }

    public static void registerBrewingRecipe() {
        TEMP.forEach(Runnable::run);
    }

    private static void regPotion2(String id, Supplier<MobEffect> sup, Supplier<Item> item, int dur, int durLong) {
        RegistryEntry potion = CCEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur)}));
        RegistryEntry longPotion = CCEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
        });
    }

    public static void register() {
    }

    static {
        CCEffects.regPotion2("crit_rate", () -> CRIT_RATE.get(), () -> CCItems.OCEAN_ESSENCE.get(), 6000, 9600);
        CCEffects.regPotion2("crit_damage", () -> CRIT_DAMAGE.get(), () -> CCItems.FIRE_ESSENCE.get(), 6000, 9600);
        CCEffects.regPotion2("regen_rate", () -> REPLY_POWER.get(), () -> CCItems.LIGHT_FRAGMENT.get(), 6000, 9600);
    }
}

