/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_overhaul.content;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.xiaoyue.celestial_overhaul.api.CanBlockItem;
import com.xiaoyue.celestial_overhaul.api.WeaponBlockedEvent;
import com.xiaoyue.celestial_overhaul.data.COModConfig;
import com.xiaoyue.celestial_overhaul.data.COTagGen;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WeaponBlockHandler {
    public static boolean isCurrentItem(ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof CanBlockItem || stack.m_204117_(COTagGen.CAN_BLOCK_SWORD);
    }

    public static int getItemDamaged(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CanBlockItem) {
            CanBlockItem item2 = (CanBlockItem)item;
            return item2.getItemDamaged(stack);
        }
        return 3;
    }

    public static float getHurtModifier(ItemStack stack, LivingEntity entity, DamageSource source) {
        float baseModifier;
        Item item = stack.m_41720_();
        if (item instanceof CanBlockItem) {
            CanBlockItem item2 = (CanBlockItem)item;
            baseModifier = item2.getHurtModifier(stack, entity, source);
        } else {
            baseModifier = 0.5f;
        }
        WeaponBlockedEvent event = new WeaponBlockedEvent(stack, entity, source, baseModifier);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getDamageModifier();
    }

    public static int getBlockTime(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CanBlockItem) {
            CanBlockItem item2 = (CanBlockItem)item;
            return item2.getBlockTime(stack);
        }
        return 72000;
    }

    public static boolean isBlocking(LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_6117_()) {
            return WeaponBlockHandler.canBlock(player.m_21205_());
        }
        return false;
    }

    public static boolean canBlock(ItemStack stack) {
        if (!((Boolean)COModConfig.COMMON.canUseSwordBlock.get()).booleanValue()) {
            return false;
        }
        if (stack.m_204117_(COTagGen.CANNOT_BLOCK_SWORD)) {
            return false;
        }
        return stack.m_41780_().equals((Object)UseAnim.BLOCK) && WeaponBlockHandler.isCurrentItem(stack);
    }

    public static void renderBlock(PoseStack poseStack, boolean right) {
        int i = right ? 1 : -1;
        poseStack.m_252880_((float)i * -0.14142136f, 0.08f, 0.14142136f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-102.25f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 13.365f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * 78.05f));
    }
}

