/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.v1.crokckpot;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.api.task.v1.cook.IHandlerCookBe;
import com.github.wallev.maidsoulkitchen.api.task.v1.cook.IItemHandlerCook;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.RegisterData;
import com.github.wallev.maidsoulkitchen.inventory.tooltip.CrockPotTooltip;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;

public class TaskCpCrockPot
implements ICookTask<CrockPotBlockEntity, CrockPotCookingRecipe>,
IHandlerCookBe<CrockPotBlockEntity>,
IItemHandlerCook<CrockPotBlockEntity, CrockPotCookingRecipe> {
    private static final Map<CrockPotCookingRecipe, MaidRec<CrockPotCookingRecipe>> RECS = new HashMap<CrockPotCookingRecipe, MaidRec<CrockPotCookingRecipe>>();
    private static final Map<FoodCategory, List<Item>> FOOD_CATEGORY_INGREDIENT_MAP = new HashMap<FoodCategory, List<Item>>();
    private static final Map<IRequirement, FoodCategory> REQUIREMENT_FOOD_CATEGORY_MAP = new HashMap<IRequirement, FoodCategory>();
    private static final Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP = new HashMap<IRequirement, List<Item>>();
    private static final Map<FoodCategory, FoodValue> REQUIREMENT_FOOD_VALUE_HASH_MAP = new HashMap<FoodCategory, FoodValue>();
    private static final Set<Item> INVID_ITEMS = new HashSet<Item>();

    private static Set<Item> getQuireItemSet(IRequirement requirement) {
        return new HashSet<Item>(TaskCpCrockPot.getQuireItems(requirement));
    }

    private static List<Item> getQuireItems(IRequirement requirement) {
        return REQUIREMENT_INGREDIENTY_MAP.get(requirement);
    }

    @NotNull
    private static Pair<List<Integer>, List<Item>> getListListPair(Map<Item, Integer> available, boolean[] single, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        int maxCount = 64;
        if (single[0]) {
            maxCount = 1;
        } else {
            for (Item item : itemTimes.keySet()) {
                maxCount = Math.min(maxCount, item.m_7968_().m_41741_());
                maxCount = Math.min(maxCount, available.get(item) / itemTimes.get(item));
            }
        }
        if (maxCount == 0) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<Integer> countList = new ArrayList<Integer>();
        for (Item item : invIngredient) {
            countList.add(maxCount);
            available.put(item, available.get(item) - maxCount);
        }
        return Pair.of(countList, new ArrayList<Item>(invIngredient));
    }

    private boolean crockPotRecMatch(ServerLevel serverLevel, CrockPotBlockEntity blockEntity) {
        Optional recipeFor;
        for (int i = 0; i < this.getInputSize(); ++i) {
            if (!blockEntity.getItemHandler().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        CrockPotCookingRecipe.Wrapper recipeWrapper = blockEntity.getRecipeWrapper();
        if (recipeWrapper != null && (recipeFor = CrockPotCookingRecipe.getRecipeFor((CrockPotCookingRecipe.Wrapper)recipeWrapper, (Level)serverLevel)).isPresent()) {
            return ((CrockPotCookingRecipe)recipeFor.get()).m_6423_().m_135815_().equals("crock_pot_cooking/wet_goop");
        }
        return false;
    }

    private static void categorizeRequirements(List<IRequirement> requirements, RecInfo1 recInfo1) {
        TaskCpCrockPot.categorizeRequirements(requirements, recInfo1.getNoRequires(), recInfo1.getMaxRequires(), recInfo1.getMaxERequires(), recInfo1.getAnyRequires(), recInfo1.getMinERequires(), recInfo1.getMinRequires(), recInfo1.getMustRequires(), recInfo1.getMustLessRequires());
    }

    private static void categorizeRequirements(List<IRequirement> requirements, List<RequirementCategoryMax> noRequires, List<RequirementCategoryMax> maxRequires, List<RequirementCategoryMaxExclusive> maxERequires, List<RequirementCategoryMinExclusive> anyRequires, List<RequirementCategoryMinExclusive> minERequires, List<RequirementCategoryMin> minRequires, List<RequirementMustContainIngredient> mustRequires, List<RequirementMustContainIngredientLessThan> mustLessRequires) {
        for (IRequirement requirement : requirements) {
            if (requirement instanceof RequirementCategoryMax) {
                RequirementCategoryMax requirementCategoryMax = (RequirementCategoryMax)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMax.getMax())) {
                    noRequires.add(requirementCategoryMax);
                    continue;
                }
                maxRequires.add(requirementCategoryMax);
                continue;
            }
            if (requirement instanceof RequirementCategoryMinExclusive) {
                RequirementCategoryMinExclusive requirementCategoryMinExclusive = (RequirementCategoryMinExclusive)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMinExclusive.getMin())) {
                    anyRequires.add(requirementCategoryMinExclusive);
                    continue;
                }
                minERequires.add(requirementCategoryMinExclusive);
                continue;
            }
            if (requirement instanceof RequirementCategoryMin) {
                RequirementCategoryMin requirementCategoryMin = (RequirementCategoryMin)requirement;
                minRequires.add(requirementCategoryMin);
                continue;
            }
            if (requirement instanceof RequirementCategoryMaxExclusive) {
                RequirementCategoryMaxExclusive requirementCategoryMaxE = (RequirementCategoryMaxExclusive)requirement;
                maxERequires.add(requirementCategoryMaxE);
                continue;
            }
            if (requirement instanceof RequirementMustContainIngredient) {
                RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                mustRequires.add(requirementMustContainIngredient);
                continue;
            }
            if (!(requirement instanceof RequirementMustContainIngredientLessThan)) continue;
            RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
            mustLessRequires.add(requirementMustContainIngredientLessThan);
        }
    }

    private static void removeNoRequiresItems(List<RequirementCategoryMax> noRequires, Set<Item> itemSet) {
        for (RequirementCategoryMax noRequire : noRequires) {
            Set<Item> quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)noRequire);
            itemSet.removeAll(quireItems);
        }
    }

    private static boolean processAnyRequires(int times, List<RequirementCategoryMinExclusive> anyRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (anyRequires.isEmpty()) {
            return true;
        }
        for (RequirementCategoryMinExclusive anyRequire : anyRequires) {
            for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                Set<Item> quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)anyRequire);
                for (Item item : itemSet) {
                    if (!quireItems.contains(item)) continue;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    ItemStack stack = item.m_7968_();
                    invIngredient.add(item);
                    if (stack.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    hasIngredient = true;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processMustRequires(int times, List<RequirementMustContainIngredient> mustRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (mustRequires.isEmpty()) {
            return true;
        }
        for (RequirementMustContainIngredient mustRequire : mustRequires) {
            for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                Set<Item> quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)mustRequire);
                int quantity = mustRequire.getQuantity();
                for (Item item : itemSet) {
                    if (!quireItems.contains(item)) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        if (--quantity != 0) continue;
                        hasIngredient = true;
                        break;
                    }
                    if (quantity != 0) continue;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processMinRequires(int times, List<RequirementCategoryMin> minRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (minRequires.isEmpty()) {
            return true;
        }
        float mMinAmount = (float)leftUnlockSlot[0] / (float)minRequires.size();
        for (RequirementCategoryMin minRequire : minRequires) {
            for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(minRequire.getCategory());
                Map<Item, Float> itemValues = foodValue.itemValues();
                float hasValue = 0.0f;
                for (Map.Entry<Item, Integer> itemIntegerEntry : itemTimes.entrySet()) {
                    hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)itemIntegerEntry.getValue().intValue();
                }
                float min = minRequire.getMin() - hasValue;
                float singleMin = min / mMinAmount;
                float value = 0.0f;
                for (Item item : itemSet) {
                    float itemValue;
                    if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) < singleMin) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        float f;
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        value += itemValue;
                        if (!(f >= min)) continue;
                        hasIngredient = true;
                        break;
                    }
                    if (!(value >= min)) continue;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processMinERequires(int times, List<RequirementCategoryMinExclusive> minERequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (minERequires.isEmpty()) {
            return true;
        }
        float mMinEAmount = (float)leftUnlockSlot[0] / (float)minERequires.size();
        for (RequirementCategoryMinExclusive minERequire : minERequires) {
            for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(minERequire.getCategory());
                Map<Item, Float> itemValues = foodValue.itemValues();
                float hasValue = 0.0f;
                for (Map.Entry<Item, Integer> itemIntegerEntry : itemTimes.entrySet()) {
                    hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)itemIntegerEntry.getValue().intValue();
                }
                float min = minERequire.getMin() - hasValue;
                float singleMin = min / mMinEAmount;
                float value = 0.0f;
                for (Item item : itemSet) {
                    float itemValue;
                    if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) <= singleMin) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        float f;
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        value += itemValue;
                        if (!(f > min)) continue;
                        hasIngredient = true;
                        break;
                    }
                    if (!(value > min)) continue;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processMaxRequires(int times, List<RequirementCategoryMax> maxRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (maxRequires.isEmpty()) {
            return true;
        }
        float mMaxAmount = (float)leftUnlockSlot[0] / (float)maxRequires.size();
        for (RequirementCategoryMax maxRequire : maxRequires) {
            block1: for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(maxRequire.getCategory());
                Map<Item, Float> itemValues = foodValue.itemValues();
                float hasValue = 0.0f;
                for (Map.Entry<Item, Integer> itemIntegerEntry : itemTimes.entrySet()) {
                    hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)itemIntegerEntry.getValue().intValue();
                }
                float max = maxRequire.getMax() - hasValue;
                float singleMin = max / mMaxAmount;
                float value = 0.0f;
                if (singleMin <= 0.0f) continue;
                for (Item item : itemSet) {
                    float itemValue;
                    if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) > singleMin) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        float f;
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        value += itemValue;
                        if (f >= max) break;
                    }
                    if (!(value >= max)) continue;
                    continue block1;
                }
            }
        }
        return true;
    }

    private static boolean processMaxERequires(int times, List<RequirementCategoryMaxExclusive> maxERequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (maxERequires.isEmpty()) {
            return true;
        }
        float mMaxEAmount = (float)leftUnlockSlot[0] / (float)maxERequires.size();
        block0: for (RequirementCategoryMaxExclusive maxRequire : maxERequires) {
            block1: for (int i = 0; i < times && leftUnlockSlot[0] != 0; ++i) {
                FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(maxRequire.getCategory());
                Map<Item, Float> itemValues = foodValue.itemValues();
                float hasValue = 0.0f;
                for (Map.Entry<Item, Integer> itemIntegerEntry : itemTimes.entrySet()) {
                    hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)itemIntegerEntry.getValue().intValue();
                }
                float max = maxRequire.getMax() - hasValue;
                float singleMin = max / mMaxEAmount;
                float value = 0.0f;
                if (singleMin <= 0.0f) continue block0;
                for (Item item : itemSet) {
                    float itemValue;
                    if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) >= singleMin) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        float f;
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        value += itemValue;
                        if (f >= max) break;
                    }
                    if (!(value >= max)) continue;
                    continue block1;
                }
            }
        }
        return true;
    }

    private static boolean processEAnyRequires(int times, List<RequirementCategoryMinExclusive> anyRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (anyRequires.isEmpty()) {
            return true;
        }
        int anyTime = leftUnlockSlot[0] / anyRequires.size();
        for (RequirementCategoryMinExclusive anyRequire : anyRequires) {
            for (int i = 0; i < anyTime && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                Set<Item> quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)anyRequire);
                for (Item item : itemSet) {
                    if (!quireItems.contains(item)) continue;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    ItemStack stack = item.m_7968_();
                    invIngredient.add(item);
                    if (stack.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    hasIngredient = true;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processEMustRequires(int times, List<RequirementMustContainIngredient> mustRequires, Set<Item> itemSet, int[] leftUnlockSlot, boolean[] single, List<Item> invIngredient, Map<Item, Integer> itemTimes, Map<Item, Integer> available) {
        if (mustRequires.isEmpty()) {
            return true;
        }
        int mustSize = leftUnlockSlot[0] / mustRequires.size();
        for (RequirementMustContainIngredient mustRequire : mustRequires) {
            for (int i = 0; i < mustSize && leftUnlockSlot[0] != 0; ++i) {
                boolean hasIngredient = false;
                Set<Item> quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)mustRequire);
                int quantity = mustRequire.getQuantity();
                for (Item item : itemSet) {
                    if (!quireItems.contains(item)) continue;
                    for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                        leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                        ItemStack stack = item.m_7968_();
                        invIngredient.add(item);
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item, 1);
                        } else {
                            itemTimes.merge(item, 1, Integer::sum);
                        }
                        if (--quantity != 0) continue;
                        hasIngredient = true;
                        break;
                    }
                    if (quantity != 0) continue;
                    break;
                }
                if (hasIngredient) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof CrockPotBlockEntity;
    }

    @Override
    public RecipeType<CrockPotCookingRecipe> getRecipeType() {
        return (RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, CrockPotBlockEntity blockEntity, MaidRecipesManager<CrockPotCookingRecipe> recManager) {
        boolean canBurn;
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        ItemStackHandler itemHandler = blockEntity.getItemHandler();
        boolean cooking = blockEntity.isCooking();
        boolean b = this.crockPotRecMatch(serverLevel, blockEntity);
        boolean findFuel = ItemsUtil.findStackSlot((IItemHandler)availableInv, itemStack -> ForgeHooks.getBurnTime((ItemStack)itemStack, null) > 0) > -1;
        boolean bl = canBurn = blockEntity.isBurning() || !itemHandler.getStackInSlot(4).m_41619_() || findFuel;
        if (!itemHandler.getStackInSlot(this.getOutputSlot()).m_41619_()) {
            return true;
        }
        if (!cooking && !b && canBurn && !recManager.getRecipesIngredients().isEmpty()) {
            return true;
        }
        if (!cooking && !b && this.hasInput(itemHandler)) {
            return true;
        }
        return cooking && itemHandler.getStackInSlot(4).m_41619_() && findFuel;
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, CrockPotBlockEntity blockEntity, MaidRecipesManager<CrockPotCookingRecipe> recManager) {
        this.extract(serverLevel, maid, blockEntity, recManager);
        this.insert(serverLevel, maid, blockEntity, recManager);
        recManager.getCookInv().syncInv();
    }

    private void extract(ServerLevel serverLevel, EntityMaid maid, CrockPotBlockEntity blockEntity, MaidRecipesManager<CrockPotCookingRecipe> recManager) {
        boolean canBurn;
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        IItemHandlerModifiable ingreInv = recManager.getInputInv();
        IItemHandlerModifiable outputInv = recManager.getOutputInv();
        ItemStackHandler beInv = blockEntity.getItemHandler();
        boolean cooking = blockEntity.isCooking();
        boolean b = this.crockPotRecMatch(serverLevel, blockEntity);
        boolean findFuel = ItemsUtil.findStackSlot((IItemHandler)availableInv, itemStack -> ForgeHooks.getBurnTime((ItemStack)itemStack, null) > 0) > -1;
        boolean bl = canBurn = blockEntity.isBurning() || !beInv.getStackInSlot(4).m_41619_() || findFuel;
        if (!beInv.getStackInSlot(this.getOutputSlot()).m_41619_()) {
            this.extractOutputStack(beInv, outputInv, (BlockEntity)blockEntity);
            blockEntity.m_6596_();
        }
        if (!cooking && !b && this.hasInput(beInv)) {
            this.extractInputsStack(beInv, ingreInv, (BlockEntity)blockEntity);
            blockEntity.m_6596_();
        }
        this.pickupAction(maid);
    }

    private void insert(ServerLevel serverLevel, EntityMaid maid, CrockPotBlockEntity blockEntity, MaidRecipesManager<CrockPotCookingRecipe> recManager) {
        boolean findFuel;
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        ItemStackHandler beInv = blockEntity.getItemHandler();
        int stackSlot = ItemsUtil.findStackSlot((IItemHandler)availableInv, itemStack -> ForgeHooks.getBurnTime((ItemStack)itemStack, null) > 0);
        boolean bl = findFuel = stackSlot > -1;
        if (beInv.getStackInSlot(4).m_41619_() && findFuel) {
            ItemStack stackInSlot = availableInv.getStackInSlot(stackSlot);
            ItemStack insertItem = beInv.insertItem(4, stackInSlot.m_41777_(), false);
            stackInSlot.m_41774_(stackInSlot.m_41613_() - insertItem.m_41613_());
            blockEntity.m_6596_();
        }
        boolean canBurn = blockEntity.isBurning() || !beInv.getStackInSlot(4).m_41619_();
        boolean cooking = blockEntity.isCooking();
        boolean b = this.crockPotRecMatch(serverLevel, blockEntity);
        if (!cooking && !b && canBurn && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            this.insertInputsStack(beInv, (IItemHandlerModifiable)availableInv, (BlockEntity)blockEntity, recipeIngredient);
            blockEntity.m_6596_();
        }
        this.pickupAction(maid);
    }

    @Override
    public MaidRecipesManager<CrockPotCookingRecipe> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<CrockPotCookingRecipe>(maid, (ICookTask)this, false){

            @Override
            protected List<Pair<List<Integer>, List<Item>>> createIngres(Map<Item, Integer> available, boolean setRecipeIngres) {
                ArrayList<Pair<List<Integer>, List<Item>>> _make = new ArrayList<Pair<List<Integer>, List<Item>>>();
                available.keySet().removeIf(item -> !INVID_ITEMS.contains(item));
                RecInfo1 recInfo1 = new RecInfo1();
                for (CrockPotCookingRecipe rec : this.currentRecs) {
                    recInfo1.clear();
                    Pair<List<Integer>, List<Item>> maxCount = TaskCpCrockPot.this.getAmountIngredientA2(recInfo1, rec, available);
                    if (((List)maxCount.getFirst()).isEmpty()) continue;
                    _make.add((Pair<List<Integer>, List<Item>>)Pair.of((Object)((List)maxCount.getFirst()), (Object)((List)maxCount.getSecond())));
                }
                if (setRecipeIngres) {
                    this.setRecIngres(_make, available);
                }
                return _make;
            }
        };
    }

    protected Pair<List<Integer>, List<Item>> getAmountIngredientA2(RecInfo1 recInfo, CrockPotCookingRecipe recipe, Map<Item, Integer> available) {
        List<RequirementCategoryMax> noRequires = recInfo.noRequires;
        List<RequirementCategoryMax> maxRequires = recInfo.maxRequires;
        List<RequirementCategoryMaxExclusive> maxERequires = recInfo.maxERequires;
        List<RequirementCategoryMinExclusive> anyRequires = recInfo.anyRequires;
        List<RequirementCategoryMinExclusive> minERequires = recInfo.minERequires;
        List<RequirementCategoryMin> minRequires = recInfo.minRequires;
        List<RequirementMustContainIngredient> mustRequires = recInfo.mustRequires;
        List<RequirementMustContainIngredientLessThan> mustLessRequires = recInfo.mustLessRequires;
        List requirements = recipe.getRequirements();
        TaskCpCrockPot.categorizeRequirements(requirements, noRequires, maxRequires, maxERequires, anyRequires, minERequires, minRequires, mustRequires, mustLessRequires);
        HashSet<Item> itemSet = new HashSet<Item>(available.keySet());
        TaskCpCrockPot.removeNoRequiresItems(noRequires, itemSet);
        if (itemSet.isEmpty()) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int[] leftUnlockSlot = new int[]{4};
        boolean[] single = new boolean[]{false};
        List<Item> invIngredient = recInfo.invIngredient;
        Map<Item, Integer> itemTimes = recInfo.itemTimes;
        boolean processAnyRequires = TaskCpCrockPot.processAnyRequires(1, anyRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processAnyRequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        boolean processMustRequires = TaskCpCrockPot.processMustRequires(1, mustRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processMustRequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        boolean processMinRequires = TaskCpCrockPot.processMinRequires(1, minRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processMinRequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        boolean processMinERequires = TaskCpCrockPot.processMinERequires(1, minERequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processMinERequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        boolean processMaxRequires = TaskCpCrockPot.processMaxRequires(1, maxRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processMaxRequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        boolean processMaxERequires = TaskCpCrockPot.processMaxERequires(1, maxERequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
        if (!processMaxERequires) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        if (leftUnlockSlot[0] > 0) {
            boolean processEAnyRequires = TaskCpCrockPot.processAnyRequires(anyRequires.isEmpty() ? 0 : (anyRequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), anyRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEAnyRequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
            boolean processEMustRequires = TaskCpCrockPot.processMustRequires(mustRequires.isEmpty() ? 0 : (mustRequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), mustRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEMustRequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
            boolean processEMinRequires = TaskCpCrockPot.processMinRequires(minRequires.isEmpty() ? 0 : (minRequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), minRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEMinRequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
            boolean processEMinERequires = TaskCpCrockPot.processMinERequires(minERequires.isEmpty() ? 0 : (minERequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), minERequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEMinERequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
            boolean processEMaxRequires = TaskCpCrockPot.processMaxRequires(maxRequires.isEmpty() ? 0 : (maxRequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), maxRequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEMaxRequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
            boolean processEMaxERequires = TaskCpCrockPot.processMaxERequires(maxERequires.isEmpty() ? 0 : (maxERequires.size() >= leftUnlockSlot[0] ? 1 : leftUnlockSlot[0]), maxERequires, itemSet, leftUnlockSlot, single, invIngredient, itemTimes, available);
            if (!processEMaxERequires) {
                return Pair.of(Collections.emptyList(), Collections.emptyList());
            }
            if (leftUnlockSlot[0] == 0) {
                return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
            }
        }
        return Pair.of(Collections.emptyList(), Collections.emptyList());
    }

    protected Pair<List<Integer>, List<Item>> getAmountIngredientA1(RecInfo1 recInfo, CrockPotCookingRecipe recipe, Map<Item, Integer> available) {
        ItemStack stack;
        float singleMin;
        Set<Item> quireItems;
        List<RequirementCategoryMax> noRequires = recInfo.noRequires;
        List<RequirementCategoryMax> maxRequires = recInfo.maxRequires;
        List<RequirementCategoryMaxExclusive> maxERequires = recInfo.maxERequires;
        List<RequirementCategoryMinExclusive> anyRequires = recInfo.anyRequires;
        List<RequirementCategoryMinExclusive> minERequires = recInfo.minERequires;
        List<RequirementCategoryMin> minRequires = recInfo.minRequires;
        List<RequirementMustContainIngredient> mustRequires = recInfo.mustRequires;
        List<RequirementMustContainIngredientLessThan> mustLessRequires = recInfo.mustLessRequires;
        List requirements = recipe.getRequirements();
        for (Object requirement : requirements) {
            if (requirement instanceof RequirementCategoryMax) {
                RequirementCategoryMax requirementCategoryMax = (RequirementCategoryMax)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMax.getMax())) {
                    noRequires.add(requirementCategoryMax);
                    continue;
                }
                maxRequires.add(requirementCategoryMax);
                continue;
            }
            if (requirement instanceof RequirementCategoryMinExclusive) {
                RequirementCategoryMinExclusive requirementCategoryMinExclusive = (RequirementCategoryMinExclusive)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMinExclusive.getMin())) {
                    anyRequires.add(requirementCategoryMinExclusive);
                    continue;
                }
                minERequires.add(requirementCategoryMinExclusive);
                continue;
            }
            if (requirement instanceof RequirementCategoryMin) {
                RequirementCategoryMin requirementCategoryMin = (RequirementCategoryMin)requirement;
                minRequires.add(requirementCategoryMin);
                continue;
            }
            if (requirement instanceof RequirementCategoryMaxExclusive) {
                RequirementCategoryMaxExclusive requirementCategoryMaxE = (RequirementCategoryMaxExclusive)requirement;
                maxERequires.add(requirementCategoryMaxE);
                continue;
            }
            if (requirement instanceof RequirementMustContainIngredient) {
                RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                mustRequires.add(requirementMustContainIngredient);
                continue;
            }
            if (!(requirement instanceof RequirementMustContainIngredientLessThan)) continue;
            RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
            mustLessRequires.add(requirementMustContainIngredientLessThan);
        }
        HashSet<Item> itemSet = new HashSet<Item>(available.keySet());
        for (RequirementCategoryMax noRequire : noRequires) {
            Set<Item> quireItems2 = TaskCpCrockPot.getQuireItemSet((IRequirement)noRequire);
            itemSet.removeAll(quireItems2);
        }
        if (itemSet.isEmpty()) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int[] leftUnlockSlot = new int[]{4};
        boolean[] single = new boolean[]{false};
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        for (RequirementCategoryMinExclusive requirementCategoryMinExclusive : anyRequires) {
            boolean hasIngredient = false;
            quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)requirementCategoryMinExclusive);
            for (Item item : itemSet) {
                if (!quireItems.contains(item)) continue;
                leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                ItemStack stack2 = item.m_7968_();
                invIngredient.add(item);
                if (stack2.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                } else {
                    itemTimes.merge(item, 1, Integer::sum);
                }
                hasIngredient = true;
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        for (RequirementMustContainIngredient requirementMustContainIngredient : mustRequires) {
            boolean hasIngredient = false;
            quireItems = TaskCpCrockPot.getQuireItemSet((IRequirement)requirementMustContainIngredient);
            int quantity = requirementMustContainIngredient.getQuantity();
            for (Item item : itemSet) {
                if (!quireItems.contains(item)) continue;
                for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    ItemStack stack3 = item.m_7968_();
                    invIngredient.add(item);
                    if (stack3.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    if (--quantity != 0) continue;
                    hasIngredient = true;
                    break;
                }
                if (quantity != 0) continue;
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        float mMinAmount = (float)leftUnlockSlot[0] / (float)minRequires.size();
        for (RequirementCategoryMin minRequire : minRequires) {
            boolean hasIngredient = false;
            FoodValue foodValue2 = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(minRequire.getCategory());
            Map<Item, Float> map = foodValue2.itemValues();
            float hasValue = 0.0f;
            for (Map.Entry itemIntegerEntry : itemTimes.entrySet()) {
                hasValue += map.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)((Integer)itemIntegerEntry.getValue()).intValue();
            }
            float min = minRequire.getMin() - hasValue;
            float singleMin2 = min / mMinAmount;
            float value = 0.0f;
            for (Item item : itemSet) {
                float itemValue;
                if (!map.containsKey(item) || (itemValue = map.get(item).floatValue()) < singleMin2) continue;
                for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                    float f;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    ItemStack stack4 = item.m_7968_();
                    invIngredient.add(item);
                    if (stack4.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    value += itemValue;
                    if (!(f >= min)) continue;
                    hasIngredient = true;
                    break;
                }
                if (!(value >= min)) continue;
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        float f = (float)leftUnlockSlot[0] / (float)minERequires.size();
        for (RequirementCategoryMinExclusive minERequire : minERequires) {
            boolean hasIngredient = false;
            FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(minERequire.getCategory());
            Map<Item, Float> itemValues = foodValue.itemValues();
            float hasValue = 0.0f;
            for (Map.Entry itemIntegerEntry : itemTimes.entrySet()) {
                hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)((Integer)itemIntegerEntry.getValue()).intValue();
            }
            float min = minERequire.getMin() - hasValue;
            singleMin = min / f;
            float value = 0.0f;
            for (Item item : itemSet) {
                float itemValue;
                if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) <= singleMin) continue;
                for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                    float f2;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    stack = item.m_7968_();
                    invIngredient.add(item);
                    if (stack.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    value += itemValue;
                    if (!(f2 > min)) continue;
                    hasIngredient = true;
                    break;
                }
                if (!(value > min)) continue;
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        float mMaxAmount = (float)leftUnlockSlot[0] / (float)maxRequires.size();
        block15: for (RequirementCategoryMax maxRequire : maxRequires) {
            FoodValue foodValue = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(maxRequire.getCategory());
            Map<Item, Float> itemValues = foodValue.itemValues();
            float hasValue = 0.0f;
            for (Map.Entry itemIntegerEntry : itemTimes.entrySet()) {
                hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)((Integer)itemIntegerEntry.getValue()).intValue();
            }
            float max = maxRequire.getMax() - hasValue;
            singleMin = max / mMaxAmount;
            float value = 0.0f;
            if (singleMin <= 0.0f) continue;
            for (Item item : itemSet) {
                float itemValue;
                if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) > singleMin) continue;
                for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                    float f3;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    stack = item.m_7968_();
                    invIngredient.add(item);
                    if (stack.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    value += itemValue;
                    if (f3 >= max) break;
                }
                if (!(value >= max)) continue;
                continue block15;
            }
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        float mMaxEAmount = (float)leftUnlockSlot[0] / (float)maxERequires.size();
        block19: for (RequirementCategoryMaxExclusive requirementCategoryMaxExclusive : maxERequires) {
            FoodValue foodValue3 = REQUIREMENT_FOOD_VALUE_HASH_MAP.get(requirementCategoryMaxExclusive.getCategory());
            Map<Item, Float> itemValues = foodValue3.itemValues();
            float hasValue = 0.0f;
            for (Map.Entry itemIntegerEntry : itemTimes.entrySet()) {
                hasValue += itemValues.getOrDefault(itemIntegerEntry.getKey(), Float.valueOf(0.0f)).floatValue() * (float)((Integer)itemIntegerEntry.getValue()).intValue();
            }
            float max = requirementCategoryMaxExclusive.getMax() - hasValue;
            float singleMin3 = max / mMaxEAmount;
            float f4 = 0.0f;
            if (singleMin3 <= 0.0f) break;
            for (Item item : itemSet) {
                float itemValue;
                if (!itemValues.containsKey(item) || (itemValue = itemValues.get(item).floatValue()) >= singleMin3) continue;
                for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                    float f5;
                    leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                    ItemStack stack5 = item.m_7968_();
                    invIngredient.add(item);
                    if (stack5.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item, 1);
                    } else {
                        itemTimes.merge(item, 1, Integer::sum);
                    }
                    f4 += itemValue;
                    if (f5 >= max) break;
                }
                if (!(f4 >= max)) continue;
                continue block19;
            }
        }
        if (leftUnlockSlot[0] == 0) {
            return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
        }
        if (leftUnlockSlot[0] > 0) {
            if (!anyRequires.isEmpty()) {
                int anyTime = leftUnlockSlot[0] / anyRequires.size();
                for (RequirementCategoryMinExclusive anyRequire : anyRequires) {
                    for (int i = 0; i < anyTime; ++i) {
                        boolean hasIngredient = false;
                        Set<Item> quireItems3 = TaskCpCrockPot.getQuireItemSet((IRequirement)anyRequire);
                        for (Item item : itemSet) {
                            if (!quireItems3.contains(item)) continue;
                            leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                            ItemStack stack6 = item.m_7968_();
                            invIngredient.add(item);
                            if (stack6.m_41741_() == 1) {
                                single[0] = true;
                                itemTimes.put(item, 1);
                            } else {
                                itemTimes.merge(item, 1, Integer::sum);
                            }
                            hasIngredient = true;
                            break;
                        }
                        if (hasIngredient) continue;
                        return Pair.of(Collections.emptyList(), Collections.emptyList());
                    }
                }
                if (leftUnlockSlot[0] == 0) {
                    return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
                }
            }
            if (!mustRequires.isEmpty()) {
                int mustSize = leftUnlockSlot[0] / mustRequires.size();
                for (RequirementMustContainIngredient mustRequire : mustRequires) {
                    for (int i = 0; i < mustSize; ++i) {
                        boolean hasIngredient = false;
                        Set<Item> quireItems4 = TaskCpCrockPot.getQuireItemSet((IRequirement)mustRequire);
                        int quantity = mustRequire.getQuantity();
                        for (Item item : itemSet) {
                            if (!quireItems4.contains(item)) continue;
                            for (int integer = 0; integer < available.get(item) - itemTimes.getOrDefault(item, 0); ++integer) {
                                leftUnlockSlot[0] = leftUnlockSlot[0] - 1;
                                ItemStack stack7 = item.m_7968_();
                                invIngredient.add(item);
                                if (stack7.m_41741_() == 1) {
                                    single[0] = true;
                                    itemTimes.put(item, 1);
                                } else {
                                    itemTimes.merge(item, 1, Integer::sum);
                                }
                                if (--quantity != 0) continue;
                                hasIngredient = true;
                                break;
                            }
                            if (quantity != 0) continue;
                            break;
                        }
                        if (hasIngredient) continue;
                        return Pair.of(Collections.emptyList(), Collections.emptyList());
                    }
                }
                if (leftUnlockSlot[0] == 0) {
                    return TaskCpCrockPot.getListListPair(available, single, itemTimes, invIngredient);
                }
            }
        }
        return Pair.of(Collections.emptyList(), Collections.emptyList());
    }

    public ResourceLocation getUid() {
        return TaskInfo.CP_CROCK_POT.uid;
    }

    public ItemStack getIcon() {
        return ((Block)CrockPotBlocks.CROCK_POT.get()).m_5456_().m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.CP_CROCK_POT;
    }

    @Override
    public ItemStackHandler getItemStackHandler(CrockPotBlockEntity crockPotBlockEntity) {
        return crockPotBlockEntity.getItemHandler();
    }

    @Override
    public int getOutputSlot() {
        return 5;
    }

    @Override
    public int getInputSize() {
        return 4;
    }

    @Override
    public ItemStackHandler getBeInv(CrockPotBlockEntity crockPotBlockEntity) {
        return crockPotBlockEntity.getItemHandler();
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        CrockPotCookingRecipe crockPotCookingRecipe = (CrockPotCookingRecipe)recipe;
        return RECS.get(crockPotCookingRecipe).ingredients();
    }

    @Override
    public boolean hasEnoughFavor(EntityMaid maid) {
        return maid.getFavorabilityManager().getLevel() >= 2;
    }

    @Override
    public List<CrockPotCookingRecipe> getRecipes(Level level) {
        if (RECS.isEmpty()) {
            FOOD_CATEGORY_INGREDIENT_MAP.clear();
            REQUIREMENT_FOOD_CATEGORY_MAP.clear();
            for (FoodCategory value : FoodCategory.values()) {
                List<Item> items2 = FoodValuesDefinition.getMatchedItems((FoodCategory)value, (Level)level).stream().map(ItemStack::m_41720_).toList();
                FOOD_CATEGORY_INGREDIENT_MAP.put(value, items2);
            }
            List<CrockPotCookingRecipe> allRecipesFor = level.m_7465_().m_44013_((RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get()).stream().filter(crockPotCookingRecipe -> !crockPotCookingRecipe.m_6423_().m_135815_().equals("crock_pot_cooking/wet_goop")).toList();
            for (CrockPotCookingRecipe crockPotCookingRecipe2 : allRecipesFor) {
                NonNullList nonNullList = NonNullList.m_122779_();
                ArrayList<List<Item>> lists = new ArrayList<List<Item>>();
                for (IRequirement requirement : crockPotCookingRecipe2.getRequirements()) {
                    List<Item> list;
                    ItemStack[] items3;
                    if (REQUIREMENT_INGREDIENTY_MAP.containsKey(requirement)) {
                        List<Item> items1 = REQUIREMENT_INGREDIENTY_MAP.get(requirement);
                        lists.add(items1);
                        nonNullList.add((Object)Ingredient.m_43921_(items1.stream().map(Item::m_7968_)));
                        continue;
                    }
                    if (requirement instanceof RequirementMustContainIngredient) {
                        RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                        items3 = requirementMustContainIngredient.getIngredient().m_43908_();
                        list = Arrays.stream(items3).map(ItemStack::m_41720_).toList();
                        REQUIREMENT_INGREDIENTY_MAP.put((IRequirement)requirementMustContainIngredient, list);
                        lists.add(list);
                        nonNullList.add((Object)Ingredient.m_43927_((ItemStack[])items3));
                        continue;
                    }
                    if (requirement instanceof RequirementMustContainIngredientLessThan) {
                        RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
                        items3 = requirementMustContainIngredientLessThan.getIngredient().m_43908_();
                        list = Arrays.stream(items3).map(ItemStack::m_41720_).toList();
                        REQUIREMENT_INGREDIENTY_MAP.put((IRequirement)requirementMustContainIngredientLessThan, list);
                        lists.add(list);
                        nonNullList.add((Object)Ingredient.m_43927_((ItemStack[])items3));
                        continue;
                    }
                    JsonElement json = requirement.toJson();
                    JsonElement category2 = json.getAsJsonObject().get("category");
                    if (category2 == null) continue;
                    String category1 = category2.getAsString();
                    FoodCategory category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)category1.toUpperCase());
                    REQUIREMENT_FOOD_CATEGORY_MAP.put(requirement, category);
                    List<Item> items1 = FOOD_CATEGORY_INGREDIENT_MAP.get(category);
                    REQUIREMENT_INGREDIENTY_MAP.put(requirement, items1);
                    lists.add(items1);
                    nonNullList.add((Object)Ingredient.m_43921_(items1.stream().map(Item::m_7968_)));
                }
                RECS.put(crockPotCookingRecipe2, new MaidRec<CrockPotCookingRecipe>(crockPotCookingRecipe2, lists, (NonNullList<Ingredient>)nonNullList, crockPotCookingRecipe2.getResult()));
            }
            FOOD_CATEGORY_INGREDIENT_MAP.forEach((foodCategory, items) -> {
                HashMap<Item, Float> itemFloatHashMap = new HashMap<Item, Float>();
                for (Item item : items) {
                    FoodValues foodValues = FoodValuesDefinition.getFoodValues((ItemStack)item.m_7968_(), (Level)level);
                    itemFloatHashMap.put(item, Float.valueOf(foodValues.get(foodCategory)));
                    INVID_ITEMS.add(item);
                }
                REQUIREMENT_FOOD_VALUE_HASH_MAP.put((FoodCategory)foodCategory, new FoodValue((FoodCategory)foodCategory, (Map<Item, Float>)itemFloatHashMap));
            });
            return allRecipesFor;
        }
        return RECS.keySet().stream().toList();
    }

    @Override
    public Optional<TooltipComponent> getRecClientAmountTooltip(Recipe<?> recipe, boolean modeRandom, boolean overSize) {
        RecInfo1 recInfo1 = new RecInfo1();
        List requirements = ((CrockPotCookingRecipe)recipe).getRequirements();
        TaskCpCrockPot.categorizeRequirements(requirements, recInfo1);
        CrockPotTooltip crockPotTooltip = new CrockPotTooltip(recInfo1, REQUIREMENT_INGREDIENTY_MAP, modeRandom, overSize);
        return Optional.of(crockPotTooltip);
    }

    @Override
    public List<Component> getWarnComponent() {
        return List.of(Component.m_237115_((String)"gui.maidsoulkitchen.btn.cook_guide.info.warn").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gui.maidsoulkitchen.btn.cook_guide.info.warn.crockpot"));
    }

    public static class RecInfo1 {
        private final List<RequirementCategoryMax> noRequires = new ArrayList<RequirementCategoryMax>();
        private final List<RequirementCategoryMax> maxRequires = new ArrayList<RequirementCategoryMax>();
        private final List<RequirementCategoryMaxExclusive> maxERequires = new ArrayList<RequirementCategoryMaxExclusive>();
        private final List<RequirementCategoryMinExclusive> anyRequires = new ArrayList<RequirementCategoryMinExclusive>();
        private final List<RequirementCategoryMinExclusive> minERequires = new ArrayList<RequirementCategoryMinExclusive>();
        private final List<RequirementCategoryMin> minRequires = new ArrayList<RequirementCategoryMin>();
        private final List<RequirementMustContainIngredient> mustRequires = new ArrayList<RequirementMustContainIngredient>();
        private final List<RequirementMustContainIngredientLessThan> mustLessRequires = new ArrayList<RequirementMustContainIngredientLessThan>();
        private final List<Item> invIngredient = new ArrayList<Item>();
        private final Map<Item, Integer> itemTimes = new HashMap<Item, Integer>();

        public void clear() {
            this.noRequires.clear();
            this.maxRequires.clear();
            this.maxERequires.clear();
            this.anyRequires.clear();
            this.minERequires.clear();
            this.minRequires.clear();
            this.mustRequires.clear();
            this.mustLessRequires.clear();
            this.invIngredient.clear();
            this.itemTimes.clear();
        }

        public List<RequirementCategoryMax> getNoRequires() {
            return this.noRequires;
        }

        public List<RequirementCategoryMax> getMaxRequires() {
            return this.maxRequires;
        }

        public List<RequirementCategoryMaxExclusive> getMaxERequires() {
            return this.maxERequires;
        }

        public List<RequirementCategoryMinExclusive> getAnyRequires() {
            return this.anyRequires;
        }

        public List<RequirementCategoryMinExclusive> getMinERequires() {
            return this.minERequires;
        }

        public List<RequirementCategoryMin> getMinRequires() {
            return this.minRequires;
        }

        public List<RequirementMustContainIngredient> getMustRequires() {
            return this.mustRequires;
        }

        public List<RequirementMustContainIngredientLessThan> getMustLessRequires() {
            return this.mustLessRequires;
        }

        public List<Item> getInvIngredient() {
            return this.invIngredient;
        }

        public Map<Item, Integer> getItemTimes() {
            return this.itemTimes;
        }
    }

    public record FoodValue(FoodCategory foodCategory, Map<Item, Float> itemValues) {
    }

    public record MaidRec<R extends Recipe<? extends Container>>(R rec, List<List<Item>> items, NonNullList<Ingredient> ingredients, ItemStack result) {
    }
}

