/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.IHandlerInfo;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.FruitData;
import com.github.wallev.maidsoulkitchen.entity.passive.IAddonMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.state.BlockState;

public class MaidCompatFruitMoveTask<T extends ICompatFarmHandler & IHandlerInfo>
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    private final ICompatFarm<T, ?> task;
    private final T compatFarmHandler;
    protected int verticalSearchStart;
    private int searchStartY = 3;
    private boolean initSearchStartY = false;

    public MaidCompatFruitMoveTask(EntityMaid maid, ICompatFarm<T, ?> task, float movementSpeed) {
        this(maid, task, movementSpeed, 2);
    }

    public MaidCompatFruitMoveTask(EntityMaid maid, ICompatFarm<T, ?> task, float movementSpeed, int verticalSearchRange) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.task = task;
        this.compatFarmHandler = task.getCompatHandler(maid);
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(120);
    }

    private static void setWalkAndLookTargetMemories(LivingEntity pLivingEntity, BlockPos walkPos, BlockPos lookPos, float pSpeed, int pDistance) {
        pLivingEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(walkPos, pSpeed, pDistance));
        pLivingEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(lookPos));
    }

    public T getCompatFarmHandler() {
        return this.compatFarmHandler;
    }

    private boolean checkOwnerPos(EntityMaid maid, BlockPos mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.m_269323_() != null && mutableBlockPos.m_203195_((Position)maid.m_269323_().m_20182_(), 8.0);
    }

    protected void start(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        this.initData(pEntity);
        this.searchForDestination(pLevel, pEntity);
    }

    protected boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, BlockPos blockPos) {
        BlockState cropState = serverLevel.m_8055_(blockPos);
        return this.task.canHarvest(entityMaid, blockPos, cropState, this.compatFarmHandler);
    }

    private void initData(EntityMaid entityMaid) {
        if (!this.initSearchStartY) {
            this.initSearchStartY = true;
            this.searchStartY = ((FruitData)entityMaid.getOrCreateData(this.task.getCookDataKey(), (Object)new FruitData())).searchYOffset();
        }
        ((IAddonMaid)entityMaid).tlmk$initFakePlayer();
    }

    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }

    private static BlockPos getSearchPos(EntityMaid maid) {
        return maid.m_21536_() ? maid.m_21534_() : maid.m_20183_().m_7495_();
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid) {
        BlockPos centrePos = MaidCompatFruitMoveTask.getSearchPos(maid);
        int searchRange = (int)maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = this.verticalSearchStart; y <= this.verticalSearchRange * 2; ++y) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y, z);
                        if (maid.m_21444_((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, mutableBlockPos.m_6630_(this.searchStartY)) && this.checkPathReach(maid, (BlockPos)mutableBlockPos) && this.checkOwnerPos(maid, (BlockPos)mutableBlockPos)) {
                            MaidCompatFruitMoveTask.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)mutableBlockPos, mutableBlockPos.m_6630_(this.searchStartY), this.movementSpeed, 0);
                            maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(mutableBlockPos.m_6630_(this.searchStartY)));
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
        }
    }
}

